#include <string.h>

#include "METRICS/routingMetric.h"
#include "METRICS/bwLatencyMetric.h"
#include "METRICS/bwMetric.h"
#include "METRICS/latencyMetric.h"
#include "METRICS/nullMetric.h"
#include "global.h"

RoutingMetric *CreateNewRoutingMetric(){
  RoutingMetric *newRoutingMetric;
  switch(protocolMetric){
  case LATENCY_ONLY:
    newRoutingMetric= new LatencyMetric();
    break;
  case BW_ONLY:
    newRoutingMetric = new BWMetric();
    break;
  case BW_LATENCY:
    newRoutingMetric = new BWLatencyMetric();
    break;
  case STATIC:
    newRoutingMetric = new NullMetric();
    break;
  default:
    MyError("Invalid Protocol Metric");
  }
  return(newRoutingMetric);
}

int IsLocalCongestionSignal(){
  switch(protocolMetric){
  case LATENCY_ONLY:
    if(PROPAGATION_DELAY_FLAG){
      return(0);
    }
    else{
      return(localCongestionSignal);
    }
    break;
    
  case STATIC:
    return(0);
    break;

  case BW_LATENCY:
    return(localCongestionSignal);
    break;

  case BW_ONLY:
    return(localCongestionSignal);
    break;

  default:
    MyError("Invalid Protocol Metric!!!");
  }
  MyError("\n Should  not come here!!");
  return(0);
}

void ParseProtocolMetric(char *optarg){
  if (strcmp(optarg, "LATENCY_ONLY") == 0) {
    protocolMetric=LATENCY_ONLY;
  } else if (strcmp(optarg, "BW_LATENCY") == 0) {
    protocolMetric=BW_LATENCY;
  } else if (strcmp(optarg, "BW_ONLY") == 0) {
    protocolMetric=BW_ONLY;
  } else if (strcmp(optarg, "STATIC") == 0){
    protocolMetric=STATIC;
  } else{
    MyError("Invalid protocol metric !!!!");
  }
}


void ParseProbeMethod(char *optarg){
  if (strcmp(optarg, "RANDOM") == 0) {
    probeMethod = RANDOM;
  } else if (strcmp(optarg, "RANDOM_10K") == 0){
    probeMethod = RANDOM_10K;
  } else if (strcmp(optarg, "RANDOM_TFRC") == 0){
    probeMethod = RANDOM_TFRC;
  } else if (strcmp(optarg, "GNP") == 0) {
    probeMethod = GNP;
  } else if (strcmp(optarg, "GNP_10K") == 0){
    probeMethod = GNP_10K;
  } else if (strcmp(optarg, "GNP_TFRC") == 0){
    probeMethod = GNP_TFRC;
  } else if (strcmp(optarg, "RTT") == 0){
    probeMethod = RTT;
  } else if (strcmp(optarg, "RTT_10K") == 0){
    probeMethod = RTT_10K;
  } else if (strcmp(optarg, "RTT_TFRC") == 0){
    probeMethod = RTT_TFRC;
  } else if (strcmp(optarg, "GNP_10K_TFRC") == 0){
    probeMethod = GNP_10K_TFRC;
  } else if (strcmp(optarg, "RTT_10K_TFRC") == 0){
    probeMethod = RTT_10K_TFRC;
  } else if (strcmp(optarg, "HISTORY") == 0) {
    probeMethod = HISTORY;
  }
  else{
    MyError("Invalid probe method %s !!!!", optarg);
  }

  switch(protocolMetric){
  case STATIC:
    if(probeMethod != RANDOM){
      MyError("Invalid probeMethod for STATIC !!!");
    }
    
    break;
    
  case LATENCY_ONLY:
    if(
       (probeMethod != RANDOM) &&
       (probeMethod != GNP) &&
       (probeMethod != RTT)
       ){
      MyError("Invalid probeMethod for LATENCY_ONLY !!!");
    }
    
    break;
    
  case BW_ONLY:
    
    if(
       (probeMethod != RANDOM) &&
       (probeMethod != RANDOM_10K) &&
       (probeMethod != RANDOM_TFRC)
       ){
      MyError("Invalid probeMethod for BW_LATENCY !!!");
    }
    break;
    
  case BW_LATENCY:
    break;
    
  default:
    MyError("Invalid protocol metric !!!");
  }
  
}

ProtocolMetricType protocolMetric=BW_LATENCY;
ProbeMethodType probeMethod = RTT;

int MAX_SOURCE_RATE=1200;
int PROPAGATION_DELAY_FLAG=0;
int perPacketVerbosity=0;
int GOSSIP_PORT=5566;

/* Performance History */
char *PerformanceHistoryReadFile = NULL;
char *PerformanceHistoryWriteFile = NULL;

int timeSyncServerAddr;
