#ifndef CONTROL_AGENT_H
#define CONTROL_AGENT_H

#include "global.h"
#include "gossipPayLoad.h"

class ControlTimer;
class EstimateDelayTimer;
class GossipAgent;
class VirtualRoutingTable;
class NbrTable;


class ControlAgent{
 private:

  static const int MAX_INITIAL_CONTROL_SEQ_NUM  = 1000 ;  /* Sigcomm2 */
  static const int PERIODIC_CONTROL_UPDATE_TIMER = 10000 / TIMER_REDUCTION;
  static const int PERIODIC_ESTIMATE_DELAY_TIMER = 200 / TIMER_REDUCTION;
  static const int STARTUP_CONTROL_UPDATE_TIMER = 5000 / TIMER_REDUCTION;

  // Note: refreshes are being sent both by CONTROL_UPDATES and
  // ESTIMATE_DELAY messages - So 10 sec is a comfortable value.    
  static const int NBR_TIMEOUT = 10000 / TIMER_REDUCTION;
  static const int MAX_TEMP_NBR_TIME = 300000 / TIMER_REDUCTION;
  static const int NUM_UPDATES_STARTUP_PHASE = 5;

  ControlTimer *periodicClock;
  EstimateDelayTimer *periodicEstimateDelayClock;

  GossipAgent *gossipAgentPtr;
  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;
  int numPeriodicUpdatesSent;

 public:
  ControlAgent(GossipAgent *gossipAgentPtrIn,
	       VirtualRoutingTable *vrtPtrIn,
	       NbrTable *nbrTabPtrIn);
  ~ControlAgent();
  void SendPeriodicUpdate(void);
  void SendPeriodicEstimateDelay(void);

  void RecvControlUpdate(int fromAddr,
			 int fromPort,
			 ControlUpdateMsg *controlUpdatePtr);

  void RecvEstimateDelayRequest(int fromAddr,
				int fromPort,
				EstimateDelayRequestMsg *msgPtr);

  void RecvEstimateDelayResponse(int fromAddr,
				 int fromPort,
				 EstimateDelayResponseMsg *msgPtr);

  void RecvIntentToCancelNbrMsg(int fromAddr,
				int fromPort,
				IntentToCancelNbrMsg *msg);

  void RecvCancelNbrMsg(int fromAddr,
			int fromPort,
			CancelNbrMsg *msg);

  int GetMyAddr();

  void SendControlUpdateToAllNbrs();

};

#endif
