#ifndef CONNECTIVITY_AGENT_H 
#define CONNECTIVITY_AGENT_H

#include "gossipPayLoad.h"

class GossipAgent;
class PerformanceAgent;
class PartitionAgent;
class JoinAgent;

class VirtualRoutingTable;
class NbrTable;

class SmallProbe;

class ConnectivityAgent{
 private:
  GossipAgent *gossipAgentPtr;

  PerformanceAgent *performanceAgentPtr;
  PartitionAgent *partitionAgentPtr;
  JoinAgent *joinAgentPtr;

  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;

  SmallProbe *smallProbePtr;

  int partitionMode;
  int joinMode;
 public:
  ConnectivityAgent(GossipAgent *gossipAgentPtrIn, 
		    VirtualRoutingTable *vrtPtrIn, 
		    NbrTable *nbrTabPtrIn);
  ~ConnectivityAgent();
  SaturationCodeType DetermineSaturationLevel();
  void RecvProbeRequest(int fromAddr,int fromPort,ProbeRequestMsg *msg);
  void RecvProbeResponse(int fromAddr,int fromPort,ProbeResponseMsg *msgPtr);
  void RecvAddNbrRequest(int fromAddr,int fromPort,AddNbrRequestMsg *msgPtr);
  void RecvAddNbrResponse(int fromAddr,int fromPort,AddNbrResponseMsg *msgPtr);
  void ProcessAddNbrResponse(int fromAddr,
			     int fromPort,
			     AddNbrResponseMsg *msgPtr);
  void SendAddNbrRequest(int addrToRequest,int seqNum,AddNbrRequestType type);
  void SendNbrConfirmRequest(int addr, AddNbrResponseMsg *msgPtr);
  int RecvNbrConfirmRequest(int fromAddr, int fromPort, NbrConfirmRequestMsg *msgPtr);
  int RecvNbrConfirmResponse(int fromAddr, int fromPort, NbrConfirmResponseMsg *msgPtr);
  void RecvJoinRequest(int fromAddr, int fromPort, JoinRequestMsg *msg);
  void RecvJoinResponse(int fromAddr, int fromPort, JoinResponseMsg *msg);

  void SetPartitionMode(int partitionModeIn);
  int IsPartitionMode();

  void RecvProbeMsg(int fromAddr,int fromPort, GossipPayLoad *gossipPacketPtr);

  void RecvSmallProbeMsg(int fromAddr,int fromPort, GossipPayLoad *pktPtr);
  void ScheduleSmallProbeTest(int *member, int size, PerformanceAgent *ptr);
  void ScheduleSmallProbeTest(int *member, int size, PartitionAgent *ptr);

  void StartJoin();
};

#endif
