#include <assert.h>
#include <iostream.h>

#include "bwLevelMgr.h"

BWLevelMgr::BWLevelMgr(int maxSourceRate){

  cout << "\n Creating BW Level Mgr....";

  numBWLevels=0;

  bwLevelArray[numBWLevels++]=0;
  bwLevelArray[numBWLevels++]= (maxSourceRate * 1)/4;   // 0.25
  bwLevelArray[numBWLevels++]= (maxSourceRate * 1)/2;   // 0.5
  bwLevelArray[numBWLevels++]= (maxSourceRate * 17)/20; // 0.85
  
}

int BWLevelMgr::ComputeLevelGivenBW(int bw){
  int level;
  
  assert(bw >= 0);

  for(level=0; level < numBWLevels ;level++){
    if(bw < bwLevelArray[level]){
      break;
    }
  }  
  return(level-1);
}


int BWLevelMgr::ComputeBWGivenLevel(int level){

  assert(level >= 0);

  if(level >= numBWLevels){
    level=numBWLevels-1;
  }
  
  return(bwLevelArray[level]);
}

int BWLevelMgr::IsValidBW(int bw){
  int level;

  for(level=0; level < numBWLevels; level++){
    if(bwLevelArray[level] == bw){
      break;
    }
  }

  if(level < numBWLevels){
    return(1);
  }
  else{
    return(0);
  }
}

int BWLevelMgr::GetMaxBWLevel(){
  return(bwLevelArray[numBWLevels-1]);
}
	 
void BWLevelMgr::Print(){
  cout << "\n Num Levels: " << numBWLevels << "\n";
  for(int i=0; i < numBWLevels; i++){
    cout << bwLevelArray[i] << " ";
  }
}
