#include <iostream.h>
#include "rttEstimationTimer.h"
#include "../rttEstimationAgent.h"
#include "../global.h"

RTTEstimationTimer::RTTEstimationTimer(RTTEstimationAgent 
				       *rttEstimationAgentPtrIn){
  rttEstimationAgentPtr=rttEstimationAgentPtrIn;
}

RTTEstimationTimer::~RTTEstimationTimer(){
}

void RTTEstimationTimer::Expire(void){
  rttEstimationAgentPtr->SendRTTEstimator();
}

void RTTEstimationTimer::PrintTimerInfo(){
  if(verbosity > 1)
    cout << "\n" << GetCurrTime() << ": Timer - RTTEstimation Timer of " << 
      GetNameByAddr(rttEstimationAgentPtr->GetMyAddr());
}
