#include <iostream.h>
#include "controlTimer.h"
#include "../controlAgent.h"
#include "../global.h"

ControlTimer::ControlTimer(ControlAgent *controlAgentPtrIn){
  controlAgentPtr=controlAgentPtrIn;
}

ControlTimer::~ControlTimer(){
}

void ControlTimer::Expire(void){
  controlAgentPtr->SendPeriodicUpdate();
}

void ControlTimer::PrintTimerInfo(){
  if(verbosity > 1)
    cout << "\n" << GetCurrTime() << ": Timer - Control Timer of " << 
      GetNameByAddr(controlAgentPtr->GetMyAddr());
}
