#ifndef ROUTING_METRIC_H
#define ROUTING_METRIC_H

#include <Util/serializableObject.h>

class VRTEntryType;

class RoutingMetric:public SerializableObject{
 public:
  virtual ~RoutingMetric();

  /*******
       Neither input metric must be NO_ROUTE
  ********/
  virtual RoutingMetric *Merge(RoutingMetric *other) = 0;


  /**********
	-Neither input metric must be NO_ROUTE	     
	     
	Returns:
	-1 if I am better
	 0 if the two metrics are the same
	 1 if the other metric is an improvement
  ************/
  virtual int Compare(RoutingMetric *other) = 0;

  virtual void SetNoRoute() = 0;
  virtual void SetTempRoute() = 0;
  virtual void SetMetric(RoutingMetric *other) = 0;
  virtual void SetBest() = 0;

  virtual int IsNoRoute() = 0;
  virtual int IsTempRoute() = 0;
  virtual int IsValidRoute() = 0;
  virtual int IsBest() = 0;

  /**********
	   Both link, routingMetrics must be Valid (not temp, or no Route)
  ***********/
  virtual float ComputeUtilityGain(RoutingMetric *linkMetricToProbedNode,
				   RoutingMetric *routingMetricToProbedNode) = 0;

  virtual float ComputeLinkQuality() = 0; // Returns fraction between 0 and 1

  virtual void PhysicalToRouting(VRTEntryType *vrtEntryPtr) = 0;

  virtual RoutingMetric *Duplicate() = 0;
  virtual void Print() = 0;
  virtual int Size() = 0;
  virtual void ReadFromStream(InputSerializableStream *osPtr) = 0;
  virtual void WriteToStream(OutputSerializableStream *isPtr) = 0; 
};

#endif
