#ifndef NULL_METRIC_H
#define NULL_METRIC_H

#include "routingMetric.h"

class VRTEntryType;

class NullMetric: public RoutingMetric {
 private:
  static const int NO_ROUTE=-1;
  static const int TEMPORARY_ROUTE=-2;
  static const int VALID_ROUTE=0;

  int state;

  void SanityChecks(NullMetric *nullMetric);

 public:
  NullMetric();
  NullMetric(int stateIn);

  // returns copy, does not affect local copy
  NullMetric *Merge(RoutingMetric *otherMetric); 
  int Compare(RoutingMetric *otherMetric);

  void SetNoRoute();
  void SetTempRoute();
  void SetMetric(RoutingMetric *otherMetric);
  void SetBest();

  int IsNoRoute();
  int IsTempRoute();
  int IsValidRoute();
  int IsBest();

  float ComputeUtilityGain(RoutingMetric *linkMetricToProbedNode,
			   RoutingMetric *routingMetricToProbedNode);

  float ComputeLinkQuality();

  void PhysicalToRouting(VRTEntryType *vrtEntryPtr);

  NullMetric *Duplicate();
  void Print();
  int Size();
  void ReadFromStream(InputSerializableStream *osPtr);
  void WriteToStream(OutputSerializableStream *isPtr);
};

#endif
