#ifndef LATENCY_METRIC_H
#define LATENCY_METRIC_H

#include "routingMetric.h"

class LatencyMetric: public RoutingMetric {
 private:
  static const int NO_ROUTE=-1;
  static const int TEMPORARY_ROUTE=-2;
  static const int UNKNOWN_DELAY = -3;
  static const int CLOSE_NBR_DELAY = 5;
  static const int REASONABLE_DELAY = 50;
  static const float HIGH_DELAY_PENALTY = 3.0;

  int latency;

  void SanityChecks(LatencyMetric *latencyMetric);
  int IsKnown();
  int IsUnKnown();

 public:
  LatencyMetric();
  LatencyMetric(int latencyIn);

  // returns copy, does not affect local copy
  LatencyMetric *Merge(RoutingMetric *otherMetric); 
  int Compare(RoutingMetric *otherMetric);

  void SetNoRoute();
  void SetTempRoute();
  void SetMetric(RoutingMetric *otherMetric);
  void SetBest();

  int IsNoRoute();
  int IsTempRoute();
  int IsValidRoute();
  int IsBest();

  float ComputeUtilityGain(RoutingMetric *linkMetricToProbedNode,
			   RoutingMetric *routingMetricToProbedNode);

  float ComputeLinkQuality();

  void PhysicalToRouting(VRTEntryType *vrtEntryPtr);

  int IsReasonableDelay();
  int IsLowDelay();
  int IsHighDelayPenalty(LatencyMetric *linkMetric);
  int GetLatency();

  LatencyMetric *LatencyMetric::Duplicate();
  void Print();
  int Size();
  void ReadFromStream(InputSerializableStream *osPtr);
  void WriteToStream(OutputSerializableStream *isPtr);
};

#endif
