#ifndef BW_LATENCY_METRIC_H
#define BW_LATENCY_METRIC_H

#include "routingMetric.h"

class VRTEntryType;
class LatencyMetric;
class BWMetric;

class BWLatencyMetric:public RoutingMetric{
 private:
  LatencyMetric *latencyMetric;
  BWMetric *bwMetric;

  void SanityCheck(BWLatencyMetric *bwLatencyMetric);

 public:
  BWLatencyMetric();
  BWLatencyMetric(BWMetric *bwMetricIn,
		  LatencyMetric *latencyMetricIn
		  );

  ~BWLatencyMetric();

  BWLatencyMetric *Merge(RoutingMetric *otherMetric);
  int Compare(RoutingMetric *otherMetric);

  int GetBW();
  int GetLatency();

  void SetNoRoute();
  void SetTempRoute();
  void SetMetric(RoutingMetric *otherMetric);
  void SetBest();
  
  int IsNoRoute();
  int IsTempRoute();
  int IsValidRoute();
  int IsBest();
  
  float ComputeUtilityGain(RoutingMetric *linkMetricToProbedNode,
			   RoutingMetric *routingMetricToProbedNode);

  float ComputeLinkQuality(); // Returns fraction between 0 and 1
  void PhysicalToRouting(VRTEntryType *vrtEntryPtr);
  
  void SetBestBW();
  int IsBestBW();
  int IsReasonableDelay();
  int IsLowDelay();
  int IsHighDelayPenalty(BWLatencyMetric *linkMetric);

  BWLatencyMetric *Duplicate();
  void Print();
  int Size();
  void ReadFromStream(InputSerializableStream *osPtr);
  void WriteToStream(OutputSerializableStream *isPtr); 
};

#endif







