#ifndef SEQ_BUFFER_H
#define SEQ_BUFFER_H

enum DataPktType {BUF_OK=1, BUF_REORDER, BUF_DUP,BUF_LATE};

class SeqBuffer{
  static const int WINDOW_SIZE=1000;

  static const int PKT_NOT_RCV=0;
  static const int PKT_RCV=1;
  static const int PKT_INIT=2;

 private:
  int first_seq;
  int last_seq;
  int is_first;
  char ele[WINDOW_SIZE];
  
  int num_rcvd;  /* total # of pkts received, including dup, or late */
  int num_ok; 
  int num_reorder; 
  int num_dup;   
  int num_late;  

 public:
  SeqBuffer();
  ~SeqBuffer();

  /* returns BUF_OK if seq has not seen before and is expected next seq num
   *         BUF_REORDER if the seq is below lastseq, but has not seen before
   *         BUF_DUP if seq has seen before
   *         BUF_LATE if seq is out of buffer zone
   */
  enum DataPktType RecvDataPkt(int seq);
  float ComputeLoss();
  void Reset();

  int GetLastSeq();
  int GetNumPktsRcvd();
};

#endif

