#include <assert.h>
#include <sys/time.h>
#include <stdio.h>

#include "macros.h"
#include "misc.h"

int verbosity=1;

struct timeval t_start;

void SetRealCurrTime(){
  gettimeofday(&t_start, NULL);

  if(verbosity > 0){
    printf("\nSTARTTIME: %ld %ld", 
	   t_start.tv_sec, t_start.tv_usec);
  }
}


/* in ms 
 * XXX: due to time synchronization, 'time' may go backward.  We may 
 * want to enforce time going forward here.
 */
long GetRealCurrTime() {
  struct timeval t_now;
  
  gettimeofday(&t_now, NULL);

  int timeInMSec=(t_now.tv_sec - t_start.tv_sec) * 1000 +
    (t_now.tv_usec - t_start.tv_usec) / 1000;
  
  return(timeInMSec);
}

/* get curr time in microsec */
int64 getCurrTimeUs() {
  struct timeval t_now;
  gettimeofday(&t_now, NULL);
  int64 timeInUSec=(t_now.tv_sec - t_start.tv_sec) * MICROSEC +
    (t_now.tv_usec - t_start.tv_usec) ;
  return(timeInUSec);
}


struct timeval MsecToTimeval(long msec) {
  struct timeval time;
  time.tv_sec = msec/1000; 
  time.tv_usec = (msec%1000)*1000;
  return time;
}


long TimevalToMsec(struct timeval time) {
  assert(time.tv_sec >=0);
  assert(time.tv_sec*1000/1000 == time.tv_sec);
  
  return (time.tv_sec*1000+time.tv_usec/1000);
}
