#include <strings.h>

#if defined(__FreeBSD__)
#include <sys/param.h>
#else
#include <netinet/in.h>
#endif
#include <assert.h>
#include "inputSerializableStream.h"

InputSerializableStream::InputSerializableStream(char *bufIn, 
						      int bufLenIn){
  pos=0;
  buf=bufIn;
  maxBufLen=bufLenIn;
}

InputSerializableStream::~InputSerializableStream(){
}

int InputSerializableStream::IsSucc(){
  assert(pos == maxBufLen);
  return(pos == maxBufLen);
}

void InputSerializableStream::BufToVar(void *var, 
				       int varsize) {
  
  /******** 
     should use exception if buffer out-of bound during parsing
     now I use "pos" >= maxBufLen as an indicator - yhchu XXX
  ********/


  if (pos+varsize > maxBufLen) {
    pos += varsize;
    return;
  }
  
  bcopy(buf+pos, (char *)var, varsize);
  pos += varsize; 
  
}


int InputSerializableStream::ReadInt(){
  int val;
  
  BufToVar(&val, sizeof(val)); 
  val = ntohl(val); 
  return(val);
}   


void InputSerializableStream::ReadCharArray(char *var, 
					    int size) {
  BufToVar(var,size);
}
