#include <assert.h>
#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>

#include "hashtable.h"

Hashtable::Hashtable() {
  ContainerHead = NULL;
  ContainerNext = NULL;
  TableSize = 0;
}

Hashtable::~Hashtable() {
  for (struct Container *ele = ContainerHead; ele != NULL;) {
    struct Container *tmp = ele;
    ele = ele->next;
    free(tmp);
  }
}


/* returns the value, or NULL if key does not exist */
void *Hashtable::Get(void *key) {
  assert(key != NULL);

  for (struct Container *ele = ContainerHead; ele != NULL; ele = ele->next) {
    if (ele->key == key) return ele->value;
  }
  return NULL;
}


/* returns the value, NULL if key does not exist */
void *Hashtable::Remove(void *key) {
  struct Container *parent = NULL;

  for (struct Container *ele = ContainerHead; ele != NULL; ele = ele->next) {
    if (ele->key != key) {
      parent = ele;
      continue;
    }

    /* disconnect ele from the linked list */
    if (ele == ContainerHead) {
      ContainerHead = ele->next;
    } else {
      assert(parent != NULL);
      parent->next = ele->next;
    }

    /* set the proper ContainerNext element */
    if (ContainerNext == ele) ContainerNext = ContainerNext->next;

    /* set the return val, and free the container */
    void *ret = ele->value;
    free(ele);
    TableSize--;  
    assert(TableSize>=0);
    return ret;
  }

  /* nothing found */
  return NULL;
}
  
/* returns the value of the first key, NULL if the table is empty */
void *Hashtable::GetFirstKey() {
  if (ContainerHead == NULL) ContainerNext = NULL;
  else ContainerNext = ContainerHead->next;

  return ContainerHead->key;
}
  
/* returns the next value, NULL if key does not exist */
void *Hashtable::GetNextKey() {
  
  if (ContainerNext == NULL) {
    return NULL;
  } else {
    struct Container *ret = ContainerNext;
    ContainerNext = ContainerNext->next;
    return ret->key;
  }
}


/* insert the key/value pair, return 0 if success, -1 if failure */
int Hashtable::Put(void *key, void *value) {
  if (Get(key) != NULL) {
    assert(0);
    return -1;
  }

  struct Container *ele = (struct Container *)malloc(sizeof(Container));
  ele->key = key;
  ele->value = value;
  
  /* add to the link list */
  ele->next = ContainerHead;
  ContainerHead = ele;
  TableSize++;
  return 0;
}


int Hashtable::Size() {
  return TableSize;
}


//#define HASHTABLE_MAIN 1
#ifdef HASHTABLE_MAIN
int main(int argc, char *argv[]) {
  Hashtable *tbl = new Hashtable();
  void *val;

  val = tbl->Get((void *)10);
  printf("val 10 = %d\n", (int)val);

  tbl->Put((void *)10, (void *)100);

  val = tbl->Get((void *)10);
  printf("val 10 = %d\n", (int)val);

  tbl->Put((void *)20, (void *)200);
  tbl->Put((void *)30, (void *)300);

  for (val = tbl->GetFirstKey(); val != NULL; val = tbl->GetNextKey()) {
    printf("%d -> %d\n", (int)val, (int)(tbl->Get(val)));
  }

  printf("val 10,20,30 = %d,%d,%d\n", 
	 (int)(tbl->Get((void *)10)), 
	 (int)(tbl->Get((void *)20)), 
	 (int)(tbl->Get((void *)30)));

  tbl->Remove((void *)10);

  printf("val x,20,30 = %d,%d,%d\n", 
	 (int)(tbl->Get((void *)10)), 
	 (int)(tbl->Get((void *)20)), 
	 (int)(tbl->Get((void *)30)));

  tbl->Remove((void *)30);

  printf("val x,20,x = %d,%d,%d\n", 
	 (int)(tbl->Get((void *)10)), 
	 (int)(tbl->Get((void *)20)), 
	 (int)(tbl->Get((void *)30)));

  for (val = tbl->GetFirstKey(); val != NULL; val = tbl->GetNextKey()) {
    printf("%d -> %d\n", (int)val, (int)(tbl->Get(val)));
  }

}
#endif
