#ifndef ESTIMATE_BANDWIDTH_H
#define ESTIMATE_BANDWIDTH_H

#define MICROSEC 1000000

#include "macros.h"


struct EBReportList {
  long time;
  int seq;
  int byteCnt;
  
  struct EBReportList *next;
};


class EstimateBandwidth {
 private:
  int estBwHistTime;
  int estBwUnitTime;
  int64 estBwUnitUs;

  int64 startTime;
  int64 nextTime;
  int byteCnt;

  int *stat;
  int statSize;
  int nextStat;

  /* Report statistics */
  int ReportSeqNum;           /* next report seq num */ 
  int64 totalByteCnt;

  struct EBReportList *UpdateInternal(int bytes, int isReport);

 public:
  static const int NO_REPORT_AVAILABLE = -1;

  EstimateBandwidth(int estBwHistTime, int estBwUnitTime);
  ~EstimateBandwidth();
  
  /* update estimation when a piece of data is received 
   */
  void Update(int bytes);

  /* update estimation when a piece of data is received 
   * and return a report list.  It is the caller's responsibility
   * to deallocate EBReportList
   */
  struct EBReportList *UpdateAndReport(int bytes);

  /* Reports the bw available in the last bwHistTime * bwUnitTime seconds
   */
  int Report();

  int GetTotalByteCntInKB();

  int ReportSessionBw();
};

#endif

