#include <iostream.h>
#include <assert.h>

#include <Gossip/global.h>
#include <Gossip/TIMERS/timer.h>
#include <Gossip/TIMERS/timerImp.h>

#include "eventQueue.h"
#include "event.h"
#include "eventTimer.h"  

EventTimerImp::EventTimerImp(Timer *timerIn,
			     EventQueue *eventQueueIn){
  timer=timerIn;
  eventQueue=eventQueueIn;
}

EventTimerImp::~EventTimerImp(){
}

void EventTimerImp::SetTimer(int when){
  Event *eventPtr=new Event(this,GetCurrTime()+when,NULL);
  eventQueue->InsertEvent(eventPtr);
}

void EventTimerImp::DeleteTimer(){
  eventQueue->DeleteEvent(this);
}

void EventTimerImp::RecvEvent(void *eventMsg){
  assert(eventMsg == NULL);
  timer->Expire();
}

void EventTimerImp::PrintEvent(void *eventMsg){
  assert(eventMsg == NULL);
  timer->PrintTimerInfo();
}
