#include <stdio.h>
#include <Gossip/global.h>

#include "eventQueue.h"
#include "event.h"

EventQueue::EventQueue(){
  eventList=NULL;
}

EventQueue::~EventQueue(){
  EventListType *ptr=eventList;

  while(ptr != NULL){
    EventListType *tempPtr=ptr;
    ptr=ptr->next;
    if(tempPtr->event != NULL) delete tempPtr->event;
    delete tempPtr;
  }
}

Event *EventQueue::PopNextEvent(){
  if(eventList == NULL) return(NULL);
  EventListType *ptr=eventList;
  eventList=ptr->next;
  Event *nextEvent=ptr->event;
  delete ptr;
  return(nextEvent);
}


/* peek the next event in the eventQueue without poping from the queue 
 * ---  yhchu*/
Event *EventQueue::PeekNextEvent(){
  if (eventList == NULL) return(NULL);
  EventListType *ptr=eventList;
  return (ptr->event);
}

void EventQueue::InsertEvent(Event *event){
  EventListType *ptr=eventList;
  EventListType *prevPtr=NULL;
  long timeToFireEvent = event->GetTimeToFire();
  if(timeToFireEvent < GetCurrTime()) {
    /* MyError("time to fire event less than current time!"); */
    fprintf(stderr, "\nWRN: time to fire event less than cur time");
  }

  while(ptr != NULL){
    if(ptr->event->GetTimeToFire() < timeToFireEvent){
      prevPtr=ptr;
      ptr=ptr->next;
    }
    else break;
  }

  EventListType *newPtr=new EventListType;
  newPtr->event=event; 
  if(prevPtr == NULL){
    newPtr->next=eventList;
    eventList=newPtr;
  }
  else{
    newPtr->next=ptr;
    prevPtr->next=newPtr;
  }
}

void EventQueue::DeleteEvent(EventReceiver *eventReceiver){
  EventListType *ptr=eventList;
  EventListType *prevPtr=NULL;

  while(1){
    while((ptr != NULL) && (ptr->event->GetReceiver() != eventReceiver)){
      prevPtr=ptr;
      ptr=ptr->next;
    }

    if(ptr == NULL) return;
    if(prevPtr==NULL){
      eventList=ptr->next;
      delete ptr->event;
      delete ptr;
      ptr=eventList;
    }
    else{
      prevPtr->next=ptr->next;
      delete ptr->event;
      delete ptr;
      ptr=prevPtr->next;
    }
  }
}

int EventQueue::IsEmpty(){
  if(eventList == NULL) return(1);
  else return(0);
}

void EventQueue::Print(){
  EventListType *ptr=eventList;
  for(ptr=eventList; ptr != NULL; ptr=ptr->next)
    ptr->event->Print();
}

