#include "util.h"

static struct timeval start_time;

void init_time() {
        gettimeofday(&start_time, NULL);
}

int64 get_time() {
        struct timeval t;
        gettimeofday(&t, NULL);
        return (int64) (t.tv_sec - start_time.tv_sec) * 1000000
                + (t.tv_usec - start_time.tv_usec);
}

void wait(int64 delay) {
        struct timeval tdelay;
        if (delay > 0) {
                tdelay.tv_usec = (time_t) delay % MICROSEC;
                tdelay.tv_sec  = (long)   delay / MICROSEC;
                select(0, NULL, NULL, NULL, &tdelay);
        }
}
