#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/param.h>
#include <assert.h>

#include "config_unix.h"
#include "config_win32.h"

#include "util.h"
#include "config.h"
#include "equation.h"

#include "tfrcReceiver.h"
#include "tfrcDaemon.h"

#include <Util/misc.h>
#include <Util/inetMisc.h>
#include "tfrcTimer.h"
#include <Gossip/global.h>
#include "tfrcSender.h"

/************
ETBState ETBflag = ETB_DISABLED;  
ETBMethod ETBtype = ETB_HOST;
int childOfVictimIpETB = 0;
***************/

/******Sanjay: To make this compile ************/
int ETBSendDrop(int addr){
  return(FALSE);
}

int ETBRecvDrop(int addr){
  return(FALSE);
}


/* application */
int64 lastSendTime = 0;
int sendInterval;

void appInit(int max_bitrate) {
  sendInterval = 1000*8*1024/max_bitrate;   /* in usec */
  lastSendTime = get_time();
}


int64 appWait() {
  int64 ret = lastSendTime - get_time();
  if (ret < 0) ret = 0;
  return ret;
}


#ifdef CONT_SOURCE
void appProcess(TfrcSender *sender) {
  char buf[1024];

  if (lastSendTime <= get_time()) {
    sender->Send(buf, 1024);
    lastSendTime += sendInterval;
  }
}
#endif


#define LARGE_SMALL_LARGE
#ifdef LARGE_SMALL_LARGE
int64 firstTime = 0;

void appProcess(TfrcSender *sender) {
  char buf[1024];
  int localSendInterval;
  int fromStart;

  if (firstTime == 0) {
    firstTime = get_time();
  }
  
  fromStart = (lastSendTime - firstTime)/MICROSEC;
  if (fromStart <= 20) {
    localSendInterval = sendInterval;
  } else if (fromStart <= 100) {
    printf("switch to low rate\n");
    localSendInterval = MICROSEC;
  } else {
    printf("switch to high rate\n");
    localSendInterval = sendInterval;
  }

  
  if (lastSendTime <= get_time()) {
    sender->Send(buf, 1024);
    lastSendTime += localSendInterval;
  }
}
#endif



void RunSender(char *addr, int port, int64 duration, int offsetTime, 
	       int max_bitrate) {
  
  TfrcSender *sender = new TfrcSender(getInetAddrByName(addr), port);
  sender->SetBwActual(1000, offsetTime);

  int64 sim_end = get_time() + duration * MICROSEC;
  
  int fd_wid = GetFDWID();
  fd_set rs, ws;

  appInit(max_bitrate);
  for (;;) {
    FD_ZERO(&rs); FD_ZERO(&ws);
    
    int64 time = sender->SetFD(&rs, &ws)*1000;
    time = min(time, appWait());
    
    struct timeval max_wait = MsecToTimeval((long)time/1000);
    
    Select(fd_wid, &rs, &ws, (fd_set *) NULL, &max_wait);
    
    int64 cur_time = get_time();
    
    /* end of simulation */
    if (cur_time > sim_end) {
      break;
    }
    
    appProcess(sender);

    if (sender->Process(&rs, &ws, cur_time) < 0) {
      printf("\nConnection aborted or timer expired");
      break;
    }
  }
  
  printf("\nsender finished");
}


void RunReceiver(TfrcReceiver *receiver, int64 duration, int offsetTime) {
  /* quit if after 60 seconds of idle */
  receiver->SetIdleTimer(60 * (int64)MICROSEC, 
			 60 * (int64)MICROSEC);

  int64 sim_end = get_time() + duration * MICROSEC;
  int fd_wid = GetFDWID();
  fd_set rs, ws;
  for (;;) {
    FD_ZERO(&rs); FD_ZERO(&ws);
    
    long time = receiver->SetFD(&rs, &ws);
    struct  timeval max_wait = MsecToTimeval(time);
    

    /* select loop */
    /* printf("max_wait: %d\n", max_wait.tv_sec); */
    Select(fd_wid, &rs, &ws, (fd_set *) NULL, &max_wait);
    
    int64 cur_time = get_time();
    /* end of simulation */
    if (cur_time > sim_end) {
      break;
    }
    
    /* XXX should I use "if" or "while"?
     * flow control problem: which task (report or recv) should be priortized?
     */
    int len;
    char buf[1500];
    int buflen = 1500;
    if ((len = receiver->Process(&rs, &ws, buf, buflen) < 0)) {
      printf("Connection aborted\n");
      break;
    }
  }
  receiver->DebugExit();
}


void RunReceiverPort(int port, int64 duration, int offsetTime) {
  RunReceiver(new TfrcReceiver(port), duration, offsetTime);
}


void RunReceiverDaemon(int port, int64 duration, int offsetTime) {
  TfrcDaemon *daemon = new TfrcDaemon(port, duration * MICROSEC);
  
  int fd_wid = GetFDWID();
  fd_set rs, ws;
  for (;;) {
    FD_ZERO(&rs); FD_ZERO(&ws);
    
    long time = daemon->SetFD(&rs, &ws);
    struct timeval max_wait = MsecToTimeval(time/1000);
    
    /* select loop */
    /* printf("max_wait: %d\n", max_wait.tv_sec); */
    Select(fd_wid, &rs, &ws, (fd_set *) NULL, &max_wait);
    
    /* XXX should I use "if" or "while"?
     * flow control problem: which task (report or recv) should be priortized?
     */
    int ret = daemon->Process(&rs, &ws);

    if (ret < 0) {
      printf("Connection aborted or timer expired\n");
      break;
    }
    
    if (ret > 0) {
      pid_t pid;
      
      TfrcReceiver *receiver = daemon->Accept();
      
      if ((pid = fork()) == 0) {
	/* child */
	RunReceiver(receiver, duration, offsetTime);
	return;
      } else {
	delete receiver;
      } 
    }
  }
}




void Usage() {
  fprintf(stderr, "-s [remote host]: send data to a remote host\n");
  fprintf(stderr, "-r recv data from any remote host\n");
  fprintf(stderr, "-p [port 10000]\n");
  fprintf(stderr, "-t [duration 10]: simulation time in sec\n");
  fprintf(stderr, "-m [100000]: max bit rate (in Kbps)\n");
  
  fprintf(stderr, "\n");
  fprintf(stderr, "example:\n");
  fprintf(stderr, "./tfrc -s openarch -p 10000 -t 10\n");
  fprintf(stderr, "./tfrc -r -p 10000\n");
  fprintf(stderr, "\n");
}

/* handling fd events */
int main(int argc, char *argv[]) {
  int isSender = TRUE;
  char *addr = NULL;
  int port = 8265;
  int64 duration = 10;
  int max_bitrate = 100000;  /* in Kbps (max: 100Mbps) */
  int isDaemon = FALSE;

  /* parse arguments */
  if (argc <= 1) {
    fprintf(stderr, "use ./tfrc -z to invoke without arg\n");
    fprintf(stderr, "\n");
    Usage();
    exit(-1);
  }


  /* parse arguments */
  char optstr[]="zhs:p:rt:o:m:D";
  char c;
  int offsetTime = 0;
  
  while((c=getopt(argc,argv,optstr)) != -1){
    switch(c){
    case 'z':
      break;
    case 'h':
      Usage();
      exit(-1);
    case 's': {
      isSender = TRUE;
      
      addr = optarg;
      break;
    }
    case 'r': {
      isSender = FALSE;
      break;
    }
    case 'p':
      port = atoi(optarg);
      break;
    case 't': /* in sec */
      duration = atoi(optarg);
      break;
    case 'o':
      offsetTime = atoi(optarg);
      break;
    case 'm':
      max_bitrate = atoi(optarg);
      break;
    case 'D':
      isDaemon = TRUE;
      break;
    default:
      Usage();
      fprintf(stderr, "Invalid Option!!\n");
      exit(-1);
    }
  }

  if (isSender) {
    RunSender(addr, port, duration, offsetTime, max_bitrate);
  } else {
    if (duration == 10) duration = 60*60*3;

    if (isDaemon) {
      RunReceiverDaemon(port, duration, offsetTime);
    } else {
      RunReceiverPort(port, duration, offsetTime);
    }
  }
}
