#include <assert.h>
#include <stdlib.h>
#include <sys/time.h>

#include "tfrcTimer.h"

/* duration in ms */
TfrcTimer::TfrcTimer(int64 dur) {
  this->duration = dur;
  expireTime = get_time() + 24*60*60*1000*1000;  /* 1 day */
  assert(expireTime > 0);
}

/* both duration and maxInitWait in ms */
TfrcTimer::TfrcTimer(int64 dur, int64 maxInitWait) {
  this->duration = dur;
  expireTime = get_time() + maxInitWait;
}


void TfrcTimer::Update() {
  expireTime = get_time() + duration;
}


int64 TfrcTimer::Expire() {
  int64 ret = expireTime - get_time();

  if (ret < 0) ret = 0;
  return ret;
}

