#ifndef _CONFIG_H
#define _CONFIG_H

#include "config_unix.h"
#include "config_win32.h"

#define REP_SIZE 100
#define MAX_UDP_PKTSIZE 1460

#define PKT_SIZE 1460

#define RTT_DECAY 0.01            /* decay factor for exp. moving avg. */
#define BREP_DECAY 0.20           /* decay factor for reported birate */
#define REPORTS_PER_RTT 1.0       /* # of reports per rtt */

#define DEC_NO_REPORT 4           /* cut sending rate after DEC_NO_REPORT rtts without receiver report */
#define SLOWSTART_NO_REPORT 3     /* kick out of SLOWSTART after SLOWSTART_NO_REPORT rtts without receiver report */

#define tcp_tick_ 0.1
#define T_RTTVAR_BITS 2
#define T_SRTT_BITS 3

#define BUF_INDICATOR 1           /* number of inc. rtt_cur until mode switched to M_NO_INCREASE */

/* XXX this should go away yhchu */
#define HIST_SIZE 100000          /* receiver history (for loss events) */

#define M_INITRTT     0           /* different modes of operation */
#define M_SLOWSTART   1
#define M_NORMAL      2
#define M_NO_INCREASE 3           /* only in receiver */

#define EQN_K 4                   /* -> history interval expected to contain 4 losses */
#define EQN_E 4                   /* min # of loss events to look at */
#define EQN_B 2                   /* # packets ackd in TCP */
#define EQN_INC 1.0               /* sending rate increase */

struct pkt_dtg {
        u_int32 mseq;
        u_int32 dseq;
        u_int32 ts;               /* in ms */
        u_int32 rtt;              /* in ms */
        u_int32 bitrate;          /* current bitrate */
        u_int32 round;
        u_int32 mode;
};


struct rep_dtg {
        u_int32 mseq;
        u_int32 dseq;        
        u_int32 ts;               /* in ms */
        u_int32 b_rep;  /* Bps */
        u_int32 b_exp;  /* Bps */

  /* yhchu */
  u_int32 rtt_smooth;   /* double casted to u_int32 */
  u_int32 loss_smooth;  /* double casted to u_int32 */
  u_int32 bw_smooth;    /* u_int32, Kbps */
  u_int32 loss_ses;     /* double casted to u_int32 */
  u_int32 bw_ses;       /* u_int32, Kbps */
};

#endif
