#ifndef SIMULATION_DRIVER_H
#define SIMULATION_DRIVER_H

#include <fstream.h>
#include <TimerEvents/eventReceiver.h>
#include <Gossip/global.h>

class RoutingTable;
class SimGossipHost;
class Packet;
class TraceGraph;
class EventQueue;
class OverheadStat;

class SimulationDriver:public EventReceiver{
 private:
  static const int MAX_HOSTNAME_LEN=100;  /* Sigcomm2 */
  
  struct MembershipChangeType{
    long time;
    int memberAddr;
    char changeCode; // 'D' for death, 'J' for Join, 'I' for ignore
    int lowerDegreeBound;
    int upperDegreeBound;
    int sourceFlg;
    int dataPeriod;
    int dataSize;
  };

  struct StressAnalyzeType{
    int unicastCount;
    int multicastCount;
    int gossipCount;
  };

  int numRouters,numMembers,numNodes,numLinks;
  RoutingTable *routingTabPtr;
  SimGossipHost **gossipHostPtrArray;
  char *unsuccessfulMemberJoinArray;
  int numActiveMembers;
  StressAnalyzeType **stressTabPtr;
  ofstream packetLossStream;
  OverheadStat *overheadStat;

  EventQueue *eventQueue;

  TraceGraph *traceGraphPtr;
  
  enum StrategyType {UNICAST_STRATEGY,GOSSIP_STRATEGY,DVMRP_STRATEGY};
  
  void CountVirtualPath(StrategyType strategy, int source, int destination);

 public:
  SimulationDriver(EventQueue *eventQueueIn);
  ~SimulationDriver();
  void ParseTopologyFileAndComputeRoutingTable(char *topologyFile);
  void ParseMembershipChangeFile(char *membershipChangeFile);
  void JoinUnSuccessful(int addr);
  void ReadyToLeave(int addr);
  void SendPacket(int fromAddr, int toAddr, Packet *packetPtr,PacketType packetType);
  void Simulate();
  void RecvEvent(void *eventMsg);
  void PrintEvent(void *eventMsg);
  void DoDebug();
  void DoComputeLatency();
  void DoComputeControlOverhead();
  void DoComputeStress();
  void DoComputeFanout();
  void DumpRoutingTable();
  void ResetPacketsRcvd();
  void DoComputePacketLoss();
  void DoComputeKnowledge();

  int GetFirstMemberAddr();
  int GetNextMemberAddr(int addr);

  int GetNumChildren(int sourceAddr, int addr);
  void GetChildList(int *childListPtr,
		    int sourceAddr,
		    int addr);
  int GetParentAddr(int sourceAddr, int addr);
  int GetRoutingPerf(int sourceAddr, int addr);
  int GetPhysicalPerf(int sourceAddr, int addr);
  int GetNumMembers();

  void UpdateTrace();
};

#endif
