#ifndef SIM_GOSSIP_HOST_H
#define SIM_GOSSIP_HOST_H

#include <Gossip/gossipHost.h>
#include <TimerEvents/eventReceiver.h>

class GossipAgent;
class SimulationDriver;
class ApplicationAgent;
class PayLoad;
class EventQueue;
class Query;

class SimGossipHost : public EventReceiver, public GossipHost  {
  friend SimulationDriver;

 private:
  int myAddr;
  ApplicationAgent *applicationAgentPtr;
  SimulationDriver *simulationDriverPtr;
  GossipAgent *gossipAgentPtr;
  EventQueue *eventQueue;

 public:
  SimGossipHost(int myAddrIn, 
		SimulationDriver *simulationDriverPtrIn,
		EventQueue *eventQueueIn);

  ~SimGossipHost();
  void JoinGroup(int numMembers,int *memberArrayPtr,
		 int lowerDegreeBound,int upperDegreeBound,int sourceFlg,
		 int dataPeriod,int dataSize);

  void JoinUnSuccessful();
  void JoinSuccessful();

  int GetMyAddr();
  void SendToNetwork(int toAddr,
		     int toPort,
		     PayLoad *payLoadPtr,
		     PacketType packetType,
		     int priority);
  
  void RecvEvent(void *eventMsg);
  void PrintEvent(void *eventMsg);
  
  // called when gossipAgent receives multicast data for the application 
  void RecvDataForApp(const char *buf,int bufLen);

  // called when application sends multicast data to the gossipAgent 
  // The buffer is copied by gossipAgent (application must free)
  void SendDataForApp(const char *buf,int bufLen);

  // Action to take when GossipAgent has completed leave operations 
  void ReadyToLeave();
  void InitLeave(int stayOnLeaveTimeMSec);

  virtual Query *GetQueryAgent();

  void DoDebug();
};

#endif


