#include <iostream.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <Gossip/global.h>
#include <Gossip/gossipAgent.h>
#include <Gossip/query.h>
#include <TimerEvents/eventQueue.h>

#include "applicationAgent.h"
#include "simulationDriver.h"
#include "simGossipHost.h"
#include "packet.h"

SimGossipHost::SimGossipHost(int myAddrIn,
			     SimulationDriver *simulationDriverPtrIn,
			     EventQueue *eventQueueIn){
  myAddr=myAddrIn;
  gossipAgentPtr=NULL;
  simulationDriverPtr=simulationDriverPtrIn;
  eventQueue=eventQueueIn;
}

SimGossipHost::~SimGossipHost(){
  if(gossipAgentPtr != NULL) delete gossipAgentPtr;
  if(applicationAgentPtr != NULL) delete applicationAgentPtr;
  eventQueue->DeleteEvent(this);
}

void SimGossipHost::JoinGroup(int numMembers,int *memberArrayPtr,
			      int lowerDegreeBound,int upperDegreeBound,
			      int sourceFlg,int dataPeriod,int dataSize){

  applicationAgentPtr = new ApplicationAgent(this,sourceFlg,dataPeriod,dataSize);
  gossipAgentPtr = new GossipAgent(this,numMembers,memberArrayPtr,
				   lowerDegreeBound,upperDegreeBound,
				   sourceFlg);
  gossipAgentPtr->StartGossipAgent();
  applicationAgentPtr->StartSend();

}


/************
 This fuction should not be called after merge of join and partition agents.
 Sanjay, April 2002.
************/
void SimGossipHost::JoinUnSuccessful(){
  simulationDriverPtr->JoinUnSuccessful(myAddr);
  delete applicationAgentPtr;
}

/************
 This fuction should not be called after merge of join and partition agents.
 Sanjay, April 2002.
************/
void SimGossipHost::JoinSuccessful(){
  
  /***  applicationAgentPtr->JoinSuccessful(); ****/
}

int SimGossipHost::GetMyAddr(){
  return(myAddr);
}


void SimGossipHost::SendToNetwork(int toAddr,
				  int toPort,
				  PayLoad *payLoadPtr,
				  PacketType packetType,
				  int priority){

  Packet *packet = new Packet(myAddr,toAddr,UDP_CODE,GOSSIP_PORT,toPort,payLoadPtr);
  simulationDriverPtr->SendPacket(myAddr,toAddr,packet,packetType);
}


void SimGossipHost::RecvEvent(void *eventMsg){

  Packet *packet = (Packet *)eventMsg; 
  GossipPayLoad *gossipPayLoad 
    = (GossipPayLoad *)packet->GetPayLoad();
  char *msgCodeString=gossipPayLoad->GetMsgCodeString();

  // Safe casting assuming everything is going on properly. 
  // But may not be good practice.
  
  if(packet->GetToAddr() == myAddr){
    if(packet->GetToPort() == GOSSIP_PORT){ 
      
      gossipAgentPtr->RecvFromNetwork(packet->GetFromAddr(),
				      packet->GetFromPort(),
				      gossipPayLoad
				      );
    }
  }


  if(
     strcmp(msgCodeString,"DATA") &&
     strcmp(msgCodeString,"POKE_DATA") &&
     strcmp(msgCodeString,"PROBE_REQUEST") &&
     strcmp(msgCodeString,"PROBE_RESPONSE") &&
     strcmp(msgCodeString,"POKE_REQUEST") &&
     strcmp(msgCodeString,"RTT_ESTIMATOR") &&
     strcmp(msgCodeString,"ESTIMATE_DELAY_REQUEST") &&
     strcmp(msgCodeString,"ESTIMATE_DELAY_RESPONSE")
     ){
    simulationDriverPtr->UpdateTrace();
  }
  
  if(
     !strcmp(msgCodeString,"ADD_NBR_RESPONSE") 
     ){
    cout << "\n" << GetCurrTime() << ":"
	 << "AddMeshLink:" 
	 << GetNameByAddr(myAddr) << ":"
	 << GetNameByAddr(packet->GetFromAddr());
  }
  
  if(
     !strcmp(msgCodeString,"CANCEL_NBR") 
     ){
    cout << "\n" << GetCurrTime() << ":"
	 << "DropMeshLink:" 
	 << GetNameByAddr(myAddr) << ":"
	 << GetNameByAddr(packet->GetFromAddr());
  }
  
  delete packet;
  
}

void SimGossipHost::PrintEvent(void *eventMsg){
  Packet *packet = (Packet *)eventMsg;
  GossipPayLoad *gossipPayLoad = (GossipPayLoad *)packet->GetPayLoad();
  char *msgCodeString=gossipPayLoad->GetMsgCodeString();

  if (
      (
       (verbosity > 0) &&
       (
	(strcmp(msgCodeString,"DATA")) &&
	(strcmp(msgCodeString,"POKE_DATA")) &&
	(strcmp(msgCodeString,"ESTIMATE_DELAY_REQUEST")) &&
	(strcmp(msgCodeString,"ESTIMATE_DELAY_RESPONSE"))
	)
       )
      
      ||
      
      (verbosity > 1)
      ) {

      cout << "\n" << GetCurrTime() << ":Receive " <<  msgCodeString 
	   << " at host : " << GetNameByAddr(myAddr) << " from " 
	   << GetNameByAddr(packet->GetFromAddr());

      /*********
	     if(gossipPayLoad->GetCode() == ADD_NBR_RESPONSE){
	     cout << " " << gossipAgentPtr->JoinMode();
	     }
      **********/
    
  }
}


void SimGossipHost::DoDebug(){
  gossipAgentPtr->DoDebug(myAddr);
}


void SimGossipHost::RecvDataForApp(const char *buf, int bufLen) {
  applicationAgentPtr->Recv(buf,bufLen);
}

void SimGossipHost::SendDataForApp(const char *buf, int bufLen){
  gossipAgentPtr->SendDataForApp(buf,bufLen, PRIORITY_DATA_DEFAULT);
}

void SimGossipHost::ReadyToLeave(){
  //  cout << "\n" << GetCurrTime() << ":" << GetNameByAddr(myAddr) << " is Ready to Leave";
  simulationDriverPtr->ReadyToLeave(myAddr);
}

void SimGossipHost::InitLeave(int stayOnLeaveTimeMSec){
  gossipAgentPtr->InitLeave(stayOnLeaveTimeMSec);
}

Query *SimGossipHost::GetQueryAgent(){
  return(gossipAgentPtr->GetQueryAgent());
}
