#ifndef ROUTING_TABLE_H
#define ROUTING_TABLE_H
#include "../Gossip/global.h"

class SimulationDriver;


class RoutingTable{
 private:
  friend SimulationDriver;
  
  static const int INFINITY = 100000;
  static const int NIL = -1;

  struct RoutingTableEntryType{
    int successor;
    int endToendDelay;
    float endToendPacketLoss;
    int linkFlg; // Is there a direct link between the two nodes?
  };

  int numNodes;
  int numRouters;
  RoutingTableEntryType **table;

 public:
  RoutingTable(int numNodesIn,int numRoutersIn); 
  ~RoutingTable();

  void Link(int i,
	    int j,
	    int delay,
	    float packetLoss); // Link btw nodes i and j with a delay delay

  void CalculateRoutingTable();				    
  void PrintRoutingTable();

  int Route(int source,
	    int destination, 
	    int packetByteSize, 
	    PacketType packetType); 
  // Returns the delay with which packet delivered. Returns -1 if packet lost

  int GetDelay(int source,int destination);
  void LoadRoutingTable();
  void DumpRoutingTable();
};

#endif
