#ifndef PACKET_H
#define PACKET_H

class PayLoad;

const int UDP_CODE = 1;

class Packet{
 private:
  int fromAddr;
  int toAddr;
  int protocolCode;
  int fromPort;
  int toPort;      // These fields are part of UDP/TCP header in reality.
  PayLoad *payLoadPtr;			

 public:
  Packet(int fromAddrIn,int toAddrIn,int protocolCodeIn,int fromPortIn,int toPortIn,PayLoad *payLoadPtrIn);
  ~Packet();
  int GetFromAddr();
  int GetToAddr();
  int GetFromPort();
  int GetToPort();
  int GetProtocolCode();
  PayLoad *GetPayLoad();
  Packet *Duplicate();
  int Size();
  void Print();
};

#endif
