#include <assert.h>
#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <Gossip/global.h>
#include <Gossip/vrt.h>
#include <TimerEvents/eventQueue.h>
#include <TimerEvents/eventTimer.h>

#include "simGlobal.h"
#include "simulationDriver.h"


char optstr[]="t:e:v:d:D:k:S:l:c:B:F:R:I:Q:K:M:C:";
extern char *optarg;

int localCongestionSignal=0;
const int MAX_ADDRESSES = 3001;


long currTime;
char **addrToNameMapping;
EventQueue *eventQueue;

char *GetNameByAddr(int addr) {
  if(addr < 0){
    return(NULL);
  }
  return addrToNameMapping[addr];
}

long GetCurrTime() {
  return currTime;
}

void SetCurrTime(long time) {
  currTime = time;
}

TimerImp *GetTimerImplementation(Timer *timer){

  EventTimerImp *timerImp= new EventTimerImp(timer,eventQueue);
  return(timerImp);

}

void MyError(const char *format, ...) {

  /***********
  va_list ap;

  fprintf(stderr, "\nERR - exiting: ");
  va_start(ap, format);
  vfprintf(stderr, format, ap);
  fflush(stderr);

  printf("\nERR - exiting: ");
  va_start(ap, format);
  vfprintf(stdout, format, ap);
  fflush(stdout);

  ************/
  assert(0);
  exit(1);

}

void MyWarning(const char *format, ...) {

  /************
  va_list ap;

  fprintf(stderr, "\nWRN: ");
  va_start(ap, format);
  vfprintf(stderr, format, ap);
  fflush(stderr);

  printf("\nWRN: ");
  va_start(ap, format);
  vfprintf(stdout, format, ap);
  fflush(stdout);
  *************/

}


void OutOfMemory(){
  MyError("Ran out of memory!");
}



int staticFlg=0;
int debugTime=-1;
int simulationTime=DEFAULT_SIMULATION_TIME;
int debugFlg=0;
const int MAX_FILENAME_LENGTH = 100;
char debugFileName[MAX_FILENAME_LENGTH];

int latencyFlg=0;
char latencyFileName[MAX_FILENAME_LENGTH];

int stressFlg=0;
char stressFileName[MAX_FILENAME_LENGTH];

int fanoutFlg=0;
char fanoutFileName[MAX_FILENAME_LENGTH];

int computeRoutingTableMode=0;
int inputRoutingTableMode=0;
char routingTableFileName[MAX_FILENAME_LENGTH];

int knowledgeFlg=0;
char knowledgeFileName[MAX_FILENAME_LENGTH];

int overheadFlg=0;
int overheadPrintPeriod=10000;


int main(int argc, char *argv[]){
  char c;
  char topologyFile[MAX_FILENAME_LENGTH];
  char eventFile[MAX_FILENAME_LENGTH];
  
  //  set_new_handler(OutOfMemory); 
  
  protocolMetric=LATENCY_ONLY;
  VirtualRoutingTable::PRINT_SOURCE_ALONE_FLAG=1;

  while((c=getopt(argc,argv,optstr)) != -1){
    switch(c){
      /***** Options for Util library *******/

    case 'v':
      verbosity=atoi(optarg);
      break;
    case 't':
      strcpy(topologyFile,optarg);
      break;
    case 'e':
      strcpy(eventFile,optarg);
      break;

    case 'd':
      debugTime=atoi(optarg);
      break;
    case 'D':
      debugFlg=1;
      strcpy(debugFileName,optarg);
      break;
    case 'S':
      simulationTime=atoi(optarg);
      break;
    case 'l':
      latencyFlg=1;
      strcpy(latencyFileName,optarg);
      break;
    case 'c':
      overheadPrintPeriod=atoi(optarg);
      break;
    case 'C':
      overheadFlg=1;
      break;
    case 'P':
      MyError("Disabled Option !!!!");
      //strcpy(packetLossFileName,optarg);
      break;
    case 'B':
      stressFlg=1; // stress info for all members as sources
      strcpy(stressFileName,optarg);
      break;
    case 'Q':
      stressFlg=2; // stress info for members designated as sources alone
      strcpy(stressFileName,optarg);
      break;
    case 'F':
      fanoutFlg=1;
      strcpy(fanoutFileName,optarg);
      break;
    case 'R':
      computeRoutingTableMode=1;
      strcpy(routingTableFileName,optarg);
      break;
    case 'I':
      inputRoutingTableMode=1;
      strcpy(routingTableFileName,optarg);
      break;
    case 'K':
      knowledgeFlg=1;
      strcpy(knowledgeFileName,optarg);
      break;
    case 'M':
      ParseProbeMethod(optarg);
      break;
    default:
      MyError("Invalid Option!!");
      break;
    }
  }

  if(
     (overheadFlg) &&
     (overheadPrintPeriod <= 0) 
     ){ 
    MyError("Overhead Print Period must be positive");
  }

  if(computeRoutingTableMode && inputRoutingTableMode){
    MyError("Cannot use -I and -R together \n");
  }

  SetCurrTime(0);
  eventQueue= new EventQueue();
  SimulationDriver *simulationDriverPtr = 
    new SimulationDriver(eventQueue);
  simulationDriverPtr->ParseTopologyFileAndComputeRoutingTable(topologyFile);
  if(computeRoutingTableMode){
    simulationDriverPtr->DumpRoutingTable();
  }
  else{
    simulationDriverPtr->ParseMembershipChangeFile(eventFile);
    simulationDriverPtr->Simulate();
  }
}



  
