#include <iostream.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>

#include <netinet/in.h>	/* sockaddr_in{} and other Internet defns */
#include <sys/param.h>
#include <sys/socket.h>

/* timer functions */
#include <sys/time.h>

#include <Gossip/global.h>
#include <Gossip/gossipHost.h>
#include <Gossip/gossipAgent.h>
#include <Gossip/gossipPayLoad.h>
#include <Gossip/query.h>

#include <TimerEvents/eventQueue.h>
#include <TimerEvents/eventTimer.h>

#include <Util/inetMisc.h>
#include <Util/misc.h>
#include <Util/inputSerializableStream.h>
#include <Util/outputSerializableStream.h>

#include "inetGossipHost.h"


int sessionSourceAddr = -1;
EventQueue *eventQueue;
const int MAX_ADDRESSES = 3001;

char *GetNameByAddr(int addr) {
  return getInetAddrName(addr);
}

long GetCurrTime(){
  return(GetRealCurrTime());
}

TimerImp *GetTimerImplementation(Timer *timer){

  EventTimerImp *timerImp= new EventTimerImp(timer,eventQueue);
  return(timerImp);

}

/* pop and execute the next event from the queue, if needed 
 * otherwise, return the wait time from the next event
 */
long InetGossipHost::PopNextEvent() {
  Event *nextEvent;
  long nextEventTime;
  long gapToNextEvent;  /* time to the next scheduled event in ms */

  nextEvent = eventQueue->PeekNextEvent();
  assert(nextEvent != NULL);
  nextEventTime = nextEvent->GetTimeToFire();
  
  if ((nextEventTime - GetCurrTime()) <= 0) { /* clock wrap around */
    nextEvent = eventQueue->PopNextEvent();
    EventReceiver *eventReceiverPtr=nextEvent->GetReceiver();
    eventReceiverPtr->PrintEvent(nextEvent->GetMsgToDeliver());
    eventReceiverPtr->RecvEvent(nextEvent->GetMsgToDeliver());
    delete nextEvent;

    /* gapToNextEvent should be the gap to the next event XXX
     * should peek into the event queue (but zero works)
     */
    gapToNextEvent = 0;
  } else {
    gapToNextEvent = nextEventTime - GetCurrTime();
     
    /* If context switch occurs, gapToNextEvent could be less than 0 */
    if (gapToNextEvent < 0) gapToNextEvent = 0;
  }

  return gapToNextEvent;
}



InetGossipHost::InetGossipHost(int myAddrIn,
			       void (* funcSendToNetwork)
			       (int, int, const char *, int, PacketType, int),
			       void (* funcRecvDataForApp)(const char *,int)) {
  myAddr=myAddrIn;
  gossipAgentPtr=NULL;
  joinMode=1;
  readyToLeave=0;
  this->funcSendToNetwork = funcSendToNetwork;
  this->funcRecvDataForApp = funcRecvDataForApp;
  eventQueue = new EventQueue();
}


InetGossipHost::~InetGossipHost(){
  if(gossipAgentPtr != NULL) delete gossipAgentPtr;
  if(eventQueue != NULL) delete eventQueue;
}

void InetGossipHost::JoinGroup(int numMembers,int *memberArrayPtr,
			   int lowerDegreeBound,int upperDegreeBound,
			   int sourceFlg){
  gossipAgentPtr = new GossipAgent(this,numMembers, memberArrayPtr, 
				   lowerDegreeBound,upperDegreeBound,
				   sourceFlg);
  gossipAgentPtr->StartGossipAgent();

  if(verbosity > 0) {

    printf("\n %ld:JOIN: %s(<%d,%d>) %d",
	   GetCurrTime(), 
	   GetNameByAddr(this->myAddr),
	   gossipAgentPtr->GetLowerDegreeBound(),
	   gossipAgentPtr->GetUpperDegreeBound(),
	   0/* (applicationAgentPtr != NULL) */);
  }
  
}


/************
 This function is disabled after merging join, partition agents
 Sanjay, April 2002
*************/

/***********
void InetGossipHost::JoinUnSuccessful(){
  MyError("Join UnSuccessful");
}
*************/

/************
 This function is disabled after merging join, partition agents
 Sanjay, April 2002
*************/

/***************
void InetGossipHost::JoinSuccessful(){
  
  joinMode=0;

  if(verbosity > 0) {
    
  printf("\n %ld:JOIN: %s(<%d,%d>) %d",
	   GetCurrTime(), 
	   GetNameByAddr(this->myAddr),
	   gossipAgentPtr->GetLowerDegreeBound(),
	   gossipAgentPtr->GetUpperDegreeBound(),
	   0); // (applicationAgentPtr != NULL) 
	   } 

}
******************/

void InetGossipHost::LeaveGroup(int stayOnLeaveTime){
  gossipAgentPtr->InitLeave(stayOnLeaveTime);
}


/************
 This function is disabled after merging join, partition agents
 Sanjay, April 2002
*************/
/*************
int InetGossipHost::JoinMode(){
  return(joinMode);
}
*****************/

int InetGossipHost::GetMyAddr(){
  return(myAddr);
}


void InetGossipHost::SendToNetwork(int toAddr,
				   int toPort,
				   PayLoad *payLoadPtr,
				   PacketType packetType,
				   int priority) {
  char *buf;
  int bufLen;
  GossipMsgType msgType;

  bufLen=payLoadPtr->Size();
  buf = new char[bufLen];
  
  OutputSerializableStream *osPtr =
    new OutputSerializableStream(buf,bufLen);

  payLoadPtr->WriteToStream(osPtr);

  assert(osPtr->IsSucc());
  delete osPtr;
  
  msgType=((GossipPayLoad *)payLoadPtr)->GetCode();
  
  if (
      (
       (verbosity > 0) &&
       (
	(msgType != DATA) && 
	(msgType != POKE_DATA) &&
	(msgType != SMALL_PROBE_DATA) &&
	(msgType != ESTIMATE_DELAY_REQUEST) &&
	(msgType != ESTIMATE_DELAY_RESPONSE) 
	)
       )
      
      ||
      
      (verbosity > 1)
      )
    
    {
      cout << "\n" << GetCurrTime() << ":Send " 
	   << ((GossipPayLoad *)payLoadPtr)->GetMsgCodeString()
	   << " from host : " << GetNameByAddr(GetMyAddr()) << " to " 
	   << GetNameByAddr(toAddr) << " " << bufLen << " ";
      assert(bufLen < 1500); // XXX temp
    }
  
  this->funcSendToNetwork(toAddr, toPort, (const char *)buf, bufLen, 
			  packetType, priority);
  
  delete payLoadPtr;
  delete [] buf;
}  


/*
 * read a packet from the network and send to Narada for processing 
 *
 * Note: this function does not know whether data comes from
 * a TCP or UDP tunnel
 */
void InetGossipHost::RecvFromNetwork(char *buf, int bufLen, 
				     int fromAddr, int fromPort) {
  /* send to GossipAgent */

  GossipMsgType msgType;

  InputSerializableStream *isPtr=
    new InputSerializableStream(buf,bufLen);
  GossipPayLoad *payLoadPtr = new GossipPayLoad();
  payLoadPtr->ReadFromStream(isPtr);
  assert(isPtr->IsSucc());
  delete isPtr;

  msgType=payLoadPtr->GetCode();

  if (
      (
       (verbosity > 0) && 
       (
	(msgType != DATA) && 
	(msgType != POKE_DATA) &&
	(msgType != SMALL_PROBE_DATA) &&
	(msgType != ESTIMATE_DELAY_REQUEST) &&
	(msgType != ESTIMATE_DELAY_RESPONSE) 
	)
       )

      ||
      (verbosity > 1)
      ){
    
    cout << "\n" << GetCurrTime() << ":Receive " <<  
      payLoadPtr->GetMsgCodeString() << " at host : " << 
      GetNameByAddr(myAddr) << " from " << 
      GetNameByAddr(fromAddr) << " " << bufLen << " ";

    assert(bufLen < 1500); // XXX temp
    
    switch(payLoadPtr->GetCode()) {
    case ADD_NBR_RESPONSE:
      // cout << gossipAgentPtr->JoinMode();
      break;
    case ESTIMATE_DELAY_RESPONSE: 
      { 
	long old = ((EstimateDelayResponseMsg *)(payLoadPtr->GetMsg()))->GetTime();
	cout << GetCurrTime() - old ;
	break;
      }
    case PROBE_RESPONSE: 
      {
	long old = ((ProbeResponseMsg *)(payLoadPtr->GetMsg()))->GetRemoteTimeRequestSent();
	cout << GetCurrTime() -old;
	break;
      }
    default:
      break;
    }
  }
  gossipAgentPtr->RecvFromNetwork(fromAddr, fromPort, payLoadPtr);
  delete payLoadPtr;
}

void InetGossipHost::RecvDataForApp(const char *buf, int bufLen) {
  funcRecvDataForApp(buf, bufLen);
}


void InetGossipHost::SendDataForApp(const char *buf, int bufLen, 
				    int priority) {
  gossipAgentPtr->SendDataForApp(buf, bufLen, priority);
}


void InetGossipHost::DoDebug(){
  gossipAgentPtr->DoDebug(myAddr);
}

void InetGossipHost::ReadyToLeave() {
  readyToLeave=1;
}

int InetGossipHost::IsReadyToLeave() {
  return(readyToLeave);
}

Query *InetGossipHost::GetQueryAgent(){
  return(gossipAgentPtr->GetQueryAgent());
}
