#ifndef DATA_MGR_UDP_H
#define DATA_MGR_UDP_H

#include "dataMgr.h"

class DataMgrUdp : public DataMgr {
 private:
  
  int cntlFD;  /* Narada daemon, UDP */
  // DataMgrType dataMgrType;

 public:
  int DaemonPort;

  DataMgrUdp(int DaemonPort);
  
  ~DataMgrUdp();
  
  /* returns the max wait time in msec */
  int SetFD(fd_set *rs, fd_set *ws);
  
  /* return 0 if succeed, -1 if failed */
  int SendToNetwork(int toAddr, int toPort, const char *buf, 
		    int bufLen, PacketType packetType, int priority);
  
  int ReadFromNetwork(fd_set *rs, fd_set *ws, char *buf, 
		      int maxBufLen, int *fromAddr, int *fromPort);
};

#endif
