#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <strings.h>
#include <unistd.h>
#include <iostream.h>
#include <stdio.h>
#include <netdb.h>
#include <signal.h>

#include <arpa/inet.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/resource.h>  /* SUN rlimit */
#include <netinet/in.h>	/* sockaddr_in{} and other Internet defns */

#include <Util/inetMisc.h>  /* MAX_PAYLOAD_SIZE defined */

#include "../Gossip/gossipAgent.h"
#include "dataMgrUdp.h"


DataMgrUdp::DataMgrUdp(int DaemonPort) {

  /* get rid of anonying "Pollable Event" signal */
#ifdef SIGPOLL  /* Linux SunOS makes SIGPOLL == SIGIO*/
  signal(SIGPOLL, SIG_IGN);
#else /* FreeBSD */
  signal(SIGIO, SIG_IGN);
#endif

  this->DaemonPort = DaemonPort;
  
  if(verbosity > 0){
    printf("\ndata mgr is UDP");
  }
  
  /* open a UDP port for the Narada daemon 
   */
  struct sockaddr_in sock;
  
  cntlFD = Socket(AF_INET, SOCK_DGRAM, 0);
  bzero((char *)&sock, sizeof(sock));
  sock.sin_family = AF_INET;
  sock.sin_addr.s_addr = htonl(INADDR_ANY);
  sock.sin_port = htons(DaemonPort);

  SetsockoptReuseAddrPort(cntlFD);
  SetsockNonBlocking(cntlFD);
  Bind(cntlFD, (struct sockaddr *)&sock, sizeof(sock));
}


DataMgrUdp::~DataMgrUdp() {
    close(cntlFD);
}

int DataMgrUdp::SetFD(fd_set *rs, fd_set *) {

  FD_SET(cntlFD, rs);  /* Narada daemon */

  return MAX_SETFD_TIME;
}


int DataMgrUdp::ReadFromNetwork(fd_set *rs, fd_set *, char *buf, 
			     int maxBufLen, int *fromAddr, int *fromPort) {

  struct sockaddr_in sock;
  socklen_t socklen = sizeof(sock);

  /* handle control fd */
  if (! FD_ISSET(cntlFD, rs)) {
    return -1;
  }

  int bufLen;
  FD_CLR(cntlFD, rs);

  if ((bufLen = Recvfrom2(cntlFD, buf, maxBufLen, 0, 
			  (struct sockaddr *)&sock, &socklen)) < 0){
    return -1;
  } 

  *fromAddr = htonl(sock.sin_addr.s_addr);
  *fromPort = htons(sock.sin_port);

  /* emulate transient behavior: drop recvd pkts probabilistically */
  if (ETBRecvDrop(*fromAddr)) {
    return -1;  
  }

  return bufLen;
}


int DataMgrUdp::SendToNetwork(int toAddr, int toPort, const char *buf, 
			      int bufLen, PacketType packetType,
			      int priority) {
  struct sockaddr_in sock;
  
  bzero((char *)&sock, sizeof(sock));
  sock.sin_family = AF_INET;
  sock.sin_addr.s_addr = htonl(toAddr);
  sock.sin_port = htons(toPort);
  
  if (bufLen > MAX_UDP_DATA_SIZE) {
    MyError("UDP pkt too large %d", bufLen);
  }

  return Sendto2(cntlFD, buf, bufLen, 0, (struct sockaddr *)&sock, 
		 sizeof(sock), "datMgrUdp");
}
