#ifndef CONN_MGR_H
#define CONN_MGR_H

class TfrcReceiver;
class TfrcSender;

/* XXX
 * the limitation here is that there can be at most 1 unidirectional
 * connection from a remote host to the local host (i.e. one send, one rcv)
 */

struct TfrcConn {
  int addr;
  // int port;
  struct TfrcConn *next;
  int type;
  
  union {
    TfrcSender *snd;
    TfrcReceiver *rcv;
  } dir;
};

enum TfrcConnType {TFRC_SND, TFRC_RCV};

class ConnMgr {
 private:
    struct TfrcConn *ConnHead;
    struct TfrcConn *ConnNext;

 public:
    ConnMgr();
    
    struct TfrcConn *GetFirst();
    struct TfrcConn *GetNext();
    void Remove(struct TfrcConn *connIn);
    struct TfrcConn *Get(int addr, TfrcConnType type);
    struct TfrcConn *Add(int addr, TfrcConnType type, void *object);
};

#endif
