#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <strings.h>
#include <unistd.h>
#include <iostream.h>
#include <stdio.h>
#include <netdb.h>

#include <Gossip/global.h>

#include "inetProxy.h"
#include "proxyClient.h"
#include "clientMgr.h"


ClientMgr::ClientMgr() {
  numUnicastClients = 0;
  multicastClientPtr = NULL;
}


ClientMgr::~ClientMgr() {
}


void ClientMgr::UpdateMulticastClientAndChannel(int multicastAddr, int ttl,
						int port) {
  // allow only one multicast address per proxy (can be extended later) XXX
  if (multicastClientPtr == NULL) {
    multicastClientPtr = new ProxyClient(multicastAddr);
    multicastClientPtr->SetTTL(ttl);
  } else {
    assert(multicastClientPtr->GetAddr() == multicastAddr);
  }
  
  if (! multicastClientPtr->IsChannelOpen(port)) {
    multicastClientPtr->AddChannel(port);
  }
}

void ClientMgr::UpdateUnicastClientAndChannel(int pktSrcAddr, 
					      int pktSrcPort) {
  // from current clients?
  int clientID = -1;   // the client who sends the pkt
  for (int i=0; i<numUnicastClients; i++) {
    ProxyClient *client = unicastClientPtr[i];
    
    // client found
    if (client->GetAddr() == pktSrcAddr) {
      clientID = i;
      
      if (! client->IsChannelOpen(pktSrcPort)) {
	unicastClientPtr[clientID]->AddChannel(pktSrcPort);
      }
      
      break;
    }
  }
  
  // new client? add
  if (clientID == -1) {
    clientID = numUnicastClients;
    unicastClientPtr[clientID] = new ProxyClient(pktSrcAddr);
    unicastClientPtr[clientID]->AddChannel(pktSrcPort);
    numUnicastClients++;
  }
}

void ClientMgr::SendData(int pktDstPort, const char *buf, int bufLen) {
  SendData(pktDstPort, buf, bufLen, -1);
}


void ClientMgr::SendData(int pktDstPort, const char *buf, int bufLen,
			 int exceptHost) {
  // send to all unicast clients
  for (int i=0; i<numUnicastClients; i++) {
    ProxyClient *client = unicastClientPtr[i];
    
    if (client->GetAddr() == exceptHost) continue;
    
    client->SendData(pktDstPort, (const char *)buf, bufLen);
  }
  

  // send to multicast address
  /* XXX: NEED TO THINK MORE: re-send data only if app's multicast 
   * pkt ttl == 0
   */
  
  if ((multicastClientPtr != NULL) &&
      (multicastClientPtr->GetAddr() != exceptHost)) {
    multicastClientPtr->SendData(pktDstPort, (const char *)buf, bufLen);
  }
}

int ClientMgr::IsLoopbackPacket(int pktSrcAddr, int pktSrcPort) {
  if (multicastClientPtr == NULL) {
    return FALSE;
  } else {
    return multicastClientPtr->IsLoopbackPacket(pktSrcAddr, pktSrcPort);
  }
}


