#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <iostream.h>

#include <Util/misc.h>
#include <Util/inetMisc.h>
#include <Gossip/global.h>
#include <Gossip/query.h>

/******
 These declarations are kind of hackish for now.
 Should include header files later
*******/
void DoExit();
void InitiateLeave(int stayTimeOnLeave);
int IsReadyToLeave();
char *GetNameByAddr(int addr);
Query *GetQueryAgent();
void ETBActivate();

/* ETB: emulate transient behavior:
 *
 * ETB_DISABLED
 * ETB_ENABLED: feature enabled
 * ETB_QUERY: check if it should be activated
 * ETB_ACTIVATE: actively dropping packets
 * ETB_ACTIVE: actively dropping packets
 */



enum ETBState {ETB_DISABLED, ETB_ENABLED, ETB_QUERY, ETB_ACTIVATE, ETB_ACTIVE};
enum ETBMethod {ETB_HOST, ETB_LINK, ETB_LEAVE, ETB_DEATH};

static const float ETB_DROP_PROBABILITY = 0.05;  // in percentage 
static ETBState ETBflag = ETB_DISABLED;
static ETBMethod ETBtype = ETB_HOST;
static int childOfVictimIpETB;

static char *ETBtypeStr;
static int startTimeETB;  // in seconds 
static int durationETB;  // in seconds 

/***************************
ETB: emulated transient behavior 
      -X <startTime (sec)>:<duration (sec)>:<victim>:<type>
	 
      <victim> can be one of
      SELF: effect takes on this host
      A host name: effect takes on parent of that host
	 
      <type> can be one of
      HOST: network congestion near a host
      LINK: link congestion (cannot be SELF)
      LEAVE: cooperative leave
      DEATH: death (duration parameter is ignored)
	 
      XXX for network congestion, we are able to simulate 
      UDP and TFRC for now.  Some careful thoughts are needed 
      to emulate TCP ETB.
	 
************************************/


void ETBParse(char *optarg){

  ETBflag = ETB_ENABLED;
  startTimeETB = atoi(strtok(optarg, ":"));
  durationETB = atoi(strtok(NULL, ":"));
  char *victimStr = strtok(NULL, ":");
  ETBtypeStr = strtok(NULL, ":");
  
  if (strcmp(ETBtypeStr, "HOST") == 0) {
    ETBtype = ETB_HOST;
  } else if (strcmp(ETBtypeStr, "LINK") == 0) {
    ETBtype = ETB_LINK;
  } else if (strcmp(ETBtypeStr, "LEAVE") == 0) {
    ETBtype = ETB_LEAVE;
  } else if (strcmp(ETBtypeStr, "DEATH") == 0) {
    ETBtype = ETB_DEATH;
  } else {
    fprintf(stderr, "unknown ETB type %s", ETBtypeStr);
  }
  
  if (strcmp(victimStr, "SELF") == 0) {
    childOfVictimIpETB = 0;
  } else {
    childOfVictimIpETB = getInetAddrByName(victimStr);
    
    if (childOfVictimIpETB == -1) {
      fprintf(stderr,"\nhostname %s not found", victimStr);
      assert(0);
    }
  }
  
  printf("\nETB PARAM %s at %s StartsOn %d LastsFor %d\n", ETBtypeStr, 
	 victimStr, startTimeETB, durationETB);

}


void ETBAction(float timeSinceStart){

  switch(ETBflag) {
  case ETB_DISABLED:
    break;
  case ETB_QUERY:
    ETBActivate();
    break;
  case ETB_ENABLED:
    if (timeSinceStart <= startTimeETB) {
      break;
    }
    
    if (childOfVictimIpETB != 0) {
      ETBflag = ETB_QUERY;
      break;
    } else {
      // continue ETB_ACTIVE 
    }      
  case ETB_ACTIVATE:
    if (ETBtype == ETB_DEATH) {
      // leave immediately 
      DoExit();
      break;
    }
    
    if (ETBtype == ETB_LEAVE) {
      InitiateLeave(durationETB * 1000);
    }
    
    if (childOfVictimIpETB == 0) {
      cout << "\n" << GetRealCurrTime() << ":ETB START " 
	   << ETBtypeStr << " " << GetNameByAddr(GetMyAddr()) 
	   << " SELF ";
    } else {
      cout << "\n" << GetRealCurrTime() << ":ETB START " 
	   << ETBtypeStr << " " << GetNameByAddr(GetMyAddr()) 
	   << " child " << GetNameByAddr(childOfVictimIpETB);
    }
    
    ETBflag = ETB_ACTIVE;
    break;
  case ETB_ACTIVE:
    switch (ETBtype) {
    case ETB_LEAVE:
      if(IsReadyToLeave()){
	ETBflag = ETB_DISABLED;
	
	cout << "\n" << GetRealCurrTime() << ":ETB END " 
	       << GetNameByAddr(GetMyAddr());
	DoExit();
      }
      break;
    case ETB_HOST:
    case ETB_LINK:
      if (timeSinceStart >= (startTimeETB+durationETB)) {
	
	ETBflag = ETB_DISABLED;
	
	cout << "\n" << GetRealCurrTime() << ":ETB END " 
	       << GetNameByAddr(GetMyAddr());
      }
      break;
    case ETB_DEATH:
      MyError("should not be here");
      break;
    default:
      MyError("Wrong ETBtype");
      break;
      }
    break;
  default:
    MyError("Wrong ETBflag");
   }
}

void ETBActivate(){
  
  assert(ETBflag == ETB_QUERY);
  
  ETBflag = ETB_DISABLED;
  Query *queryPtr=GetQueryAgent();
  
  int source=queryPtr->GetSourceAddr();
  int numChildren=queryPtr->GetNumChildren(source);
  
  int *childAddrListPtr=new int[numChildren];
  queryPtr->GetChildList(childAddrListPtr,source);
  
  
  for(int i=0; i < numChildren; i++){
    if (childAddrListPtr[i] == childOfVictimIpETB) {
      ETBflag = ETB_ACTIVATE;
      break;
    }
  }
  
  if (
      (ETBtype == ETB_LEAVE) ||
      (ETBtype == ETB_DEATH)
      ){
    // if the victim's parent turns out to be the source, zap the 
    // victim.  XXX Does not work for multi-source
    
    if (queryPtr->IsSource()) {
      ETBflag = ETB_DISABLED;
    }
 
    int parentAddr=-1;
    int ret=queryPtr->GetParentAddr(&parentAddr,source);
    int isChildOfSourceFlg = (
			      (ret == 0) &&
			      (parentAddr == source)
			      );
      
    if ((childOfVictimIpETB == GetMyAddr()) && 
	(isChildOfSourceFlg)) {
      ETBflag = ETB_ACTIVATE;
    }
  }
}
  

int ETBSendDrop(int addr) {
  /* emulate transient behavior: do not send the pkt probabilistically */

  if (ETBflag == ETB_ACTIVE) {
    if (ETBtype == ETB_HOST ||
	(ETBtype == ETB_LINK && (childOfVictimIpETB == addr))) {
      if ((((float)rand())/((float)RAND_MAX)) < ETB_DROP_PROBABILITY) {
	return TRUE;
      }
    }
  }
  
  return FALSE;

}


int ETBRecvDrop(int addr) {

  /* emulate transient behavior: do not send the pkt probabilistically */
  if (ETBflag == ETB_ACTIVE) {
    if (ETBtype == ETB_HOST ||
	(ETBtype == ETB_LINK && (childOfVictimIpETB == addr))) {
      if ((((float)rand())/((float)RAND_MAX)) < ETB_DROP_PROBABILITY) {
	return TRUE;
      }
    }
  }

  return FALSE;

}

int IsETBEnabled(){
  return(ETBflag == ETB_ENABLED);
}
