#ifndef VRT_H
#define VRT_H

class VRTEntryType;
class UpdateRecord;
class ProbeResponseRecord;
class PerformanceHistory;

class VirtualRoutingTable{

 private:

  struct EntryType{
    EntryType *prev,*next;
    int hashValue;
    VRTEntryType *vrtEntry;
  };

  int maxTableSize;
  int numEntries;
  int numDeadRoutes;
  int myAddr;

  EntryType **table;  
  EntryType *firstEntry;

  EntryType *GetRouteEntry(int addr);  
  EntryType *GetRouteEntryApproximate(int addr);  
  EntryType *getNextRouteNextEntry;
  PerformanceHistory *performanceHistoryPtr;

  int Hash(int addr);
    
 public:

  static int PRINT_SOURCE_ALONE_FLAG;

  VirtualRoutingTable(int maxTableSizeIn,
		      int myAddrIn,
		      int numMembers,
		      int *memberArrayPtr);
  ~VirtualRoutingTable(void);
  int GetNumRoutes(void);

  /****************  
    The following functions : GetRoute,GetNextRoute
   provide direct access to routes stored for the corresponding
   addresses. The returned entry may be read or modified at will and
   this will be reflected in the table too. Similary, AddRoute takes a
   route "as is" and inserts into the table. ; It is the
   responsibility of the user not to delete storage area pointed to by
   the pointers - The user must call DeleteRoute, otherwise bad things
   will happen. This is not recommended good code design but I want
   efficiency and I am running out of patience and ideas.
  ********************/

  VRTEntryType *GetRoute(int addr); // Null if no route for that address;


  /* function GetNextRoute for sequential access of all routes in the
   * table. Returns the next route in the table. Returns NULL if no more 
   * routes. 
   *
   * IMPORTANT: you should NOT add/remove entries while in the GetNextRoute
   *    loop
   * IMPORTANT: you CANNOT have a NESTED LOOP !!!
   * For example:
   *    for (VRTEntryType *route=vrtPtr->GetNextRouteInit(); 
   *         route != NULL; 
   *         route=vrtPtr->GetNextRoute()) { ... }
   */
  VRTEntryType *GetNextRouteInit();
  VRTEntryType *GetNextRoute(); 
  VRTEntryType *GetNextRouteIncludingDeadInit(); 
  VRTEntryType *GetNextRouteIncludingDead(); 


  /******
   Returns pointer to new route if success
   NULL for failure => Eg: Route already present, no space in table
  *******/
  VRTEntryType *AddRoute(int addr);

  void DeleteRoute(int addr);
  void MarkRouteAlive(int addr);
  void MarkRouteDead(int addr);
  void Print();
  void QuickPrint();
  int UpdateTable(int numRecords,
		  UpdateRecord *updateRecordPtr,
		  int neighborAddr, 
		  int tempNbrFlg);

  /******* 
    The following functions consider the entire table and create a
    list of entries with appropriate records. They return the 
    created array of records, as well as number of records (parameter
    passed by reference)
  *********/

  UpdateRecord *CreateUpdateRecord(int *numRecords);
  ProbeResponseRecord *CreateProbeResponseRecord(int *numRecords);
  
  /********
    The functions below update every appropriate entry when a neighbor
    has been deleted or made temporary
  *********/
  int UpdateOnNbrDeletion(int nbr);
  void UpdateOnNbrTemp(int nbr);

  void Check();

  int GetMyAddr();
  void DoDebug();
};

#endif
