#ifndef SOURCE_STAT_H
#define SOURCE_STAT_H

#include "global.h"
#include <Util/seqBuffer.h>

class DataMsg;
class EstimateBandwidth;

class SourceEntry {
private:
  /*** Size of seqNum stat buffer ***/
  static const int MAX_SEQ_NUM_STAT = 300000;
  
  int sourceAddr;

  /* handle multiple sources 
   */
  EstimateBandwidth *estBwPtr;     /* smoothed bw */
  EstimateBandwidth *estBwRawPtr;  /* raw bw */

  /* XXX should use bytes later, but may wrap arond (use int64) */
  int totalNumRcvdPkts;  
  int lastSeqNumRcvd;
  int firstSeqNumRcvd;


  int numDuplicatePkts;
  int numLatePkts;

  /*** Sanjay: statistics to keep track of various received packets **/
  int maxRcvdSeqNum;
  int *rcvSeqNumStatRcvTime;
  int *rcvSeqNumStatSrcTime;
  int *rcvSeqNumStatParentAddr;
  
  // Here, though, I don't assume absolute values.
  SeqBuffer *seqBuffer;

public:
  static const int STATS_PERIOD=1000;

  SourceEntry(int sourceAddr);
  ~SourceEntry();
  enum DataPktType RecvDataPkt(DataMsg *msgPtr);
  void Update(DataMsg *msgPtr, int fromAddr);
  void DoDebug();
  int ReportBwRcvd();
};
#endif

