#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <assert.h>

#include "TIMERS/smallProbeSenderTimer.h"
#include "gossipPayLoad.h"
#include "smallProbe.h"
#include "smallProbeSender.h"

SmallProbeSender::SmallProbeSender(SmallProbe *smallProbePtr, 
				   int remoteAddr, 
				   int nonce) {
  
  this->smallProbePtr = smallProbePtr;
  this->remoteAddr = remoteAddr;
  this->nonce = nonce;
  
  timerPtr = new SmallProbeSenderTimer(this);
}


SmallProbeSender::~SmallProbeSender() {
  delete timerPtr;
}



void SmallProbeSender::StartProbe() {
  if (verbosity > 0) {
    printf("\nSmallProbeSender: start bw estimation to %s",
	   GetNameByAddr(remoteAddr));
  }
  
  seqNum = 0;
  nextTime = GetCurrTime();
  Timeout();
}


void SmallProbeSender::Timeout(){
  
  long currTime = GetCurrTime();
    
  while (nextTime - currTime <= 0) {
    SmallProbeDataMsg *msg
      = new SmallProbeDataMsg(smallProbePtr->SMALL_PROBE_PKT_SIZE, 
			      nonce, seqNum, GetCurrTime(), 0,
			      new char[smallProbePtr->SMALL_PROBE_PKT_SIZE]);

    smallProbePtr->SendToNetwork(remoteAddr, GOSSIP_PORT, 
				 SMALL_PROBE_DATA, msg);
    seqNum++;
    
    nextTime += smallProbePtr->GetProbePeriod();
    
    /* continue if time is not up yet */
    if (seqNum == smallProbePtr->SMALL_PROBE_NUM_PKTS) {
      smallProbePtr->FinishSender(this);
      return;
    }

    if (nextTime > currTime) {
      break;
    } 
  }
  timerPtr->SetTimer(nextTime - currTime);
}


int SmallProbeSender::GetAddr() {
  return remoteAddr;
}


int SmallProbeSender::GetMyAddr(){
  return(smallProbePtr->GetMyAddr());
}

