#ifndef SMALL_PROBE_RECEIVER_H
#define SMALL_PROBE_RECEIVER_H

#include "global.h"
#include "TIMERS/smallProbeReceiverTimer.h"

class SmallProbe;
class SmallProbeReceiverTimer;
class SmallProbeDataMsg;

class SmallProbeReceiver {

 private:
  SmallProbe *smallProbePtr;
  int remoteAddr;

  SmallProbeReceiverTimer *timerPtr;
  
  long startTime;
  long timeFirstPkt;
  long timeLastPkt;
  int sumNumPkts;
  long lastTime;         /* receiver only (last time pkt rcvd) */
  int nonce;             /* receiver generates, sender sets */

 public:
  SmallProbeReceiver(SmallProbe *smallProbePtr, int remoteAddr);
  ~SmallProbeReceiver();
  
  void StartProbe();
  void Timeout();
  void RecvMsg(SmallProbeDataMsg *msg);
  int GetAddr();
  int GetNonce();

  int GetMyAddr();
};

#endif

