#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <assert.h>

#include "TIMERS/smallProbeReceiverTimer.h"
#include "gossipPayLoad.h"
#include "smallProbe.h"
#include "smallProbeReceiver.h"


SmallProbeReceiver::SmallProbeReceiver(SmallProbe *smallProbePtr, 
				       int remoteAddr) {
  
  this->smallProbePtr = smallProbePtr;
  this->remoteAddr = remoteAddr;

  this->timerPtr = new SmallProbeReceiverTimer(this);
  this->nonce = GetCurrTime();

  timerPtr = new SmallProbeReceiverTimer(this);
}


SmallProbeReceiver::~SmallProbeReceiver() {
  if (timerPtr != NULL) {
    timerPtr->DeleteTimer();
    delete timerPtr;
  }
}


void SmallProbeReceiver::StartProbe() {
  timeFirstPkt = -1;
  sumNumPkts = 0;
  startTime = GetCurrTime();

  nonce = GetCurrTime();
  
  if (verbosity > 0) {
    printf("\nSmallProbeReceiver: %s -> %s Request",
	   GetNameByAddr(GetMyAddr()), GetNameByAddr(remoteAddr));
  }
    
  SmallProbeRequestMsg *msg=new SmallProbeRequestMsg(nonce);
  smallProbePtr->SendToNetwork(remoteAddr, GOSSIP_PORT, 
			       SMALL_PROBE_REQUEST, msg);
  
  /* wake up after probe finishes */
  timerPtr->SetTimer(smallProbePtr->SMALL_PROBE_RECEIVER_TIMEOUT);
}


void SmallProbeReceiver::RecvMsg(SmallProbeDataMsg *msg){
  long currTime = GetCurrTime();

  if (timeFirstPkt == -1) {
    timeFirstPkt = currTime;
  }
  
  timeLastPkt = currTime;
  
  /* do not deal with duplicated packets */
  int dataSize = msg->GetDataSize();
  int seqNum = msg->GetSeqNum();
  assert(smallProbePtr->SMALL_PROBE_PKT_SIZE == dataSize);

  sumNumPkts++;

  /* last packet: report */
  if (seqNum == (smallProbePtr->SMALL_PROBE_NUM_PKTS-1)) {
    Timeout();
  }
}


void SmallProbeReceiver::Timeout(){
  
  /* hasn't started */
  if (timeFirstPkt == -1) {
    if (verbosity > 0) {
      printf("\nSmallProbeReceiver: %s -> %s Timeout",
	     GetNameByAddr(GetMyAddr()), GetNameByAddr(remoteAddr));
    }
    
    smallProbePtr->FinishReceiver(this, -1);
    return;
  }
  
  float wait = (timeFirstPkt - startTime)/1000.0;
  float dur = (timeLastPkt - timeFirstPkt)/1000.0;

  /* fail if received less than 70% of the packet */
  if (sumNumPkts < (smallProbePtr->SMALL_PROBE_NUM_RCVD_RATIO *
		    smallProbePtr->SMALL_PROBE_NUM_PKTS)) {
    if (verbosity > 0) {
      printf("SmallProbeReceiver: %s -> %s InsufficientData %d %.2f %.2f",
	     GetNameByAddr(GetMyAddr()), GetNameByAddr(remoteAddr),
	     sumNumPkts, wait, dur);
    }

    smallProbePtr->FinishReceiver(this, -1);
    return;
  }
  

  int sumBytesRcvd = sumNumPkts * smallProbePtr->SMALL_PROBE_PKT_SIZE;

  int rate;
  if (wait+dur <= 0) {
    rate = MAX_SOURCE_RATE;
  } else {
    rate = (int)(sumBytesRcvd / (wait + dur) * 8.0 / 1024.0);
  }
  
  if (verbosity > 0) {
    printf("\nSmallProbeReceiver: %s -> %s Estimate %d %.2f %.2f %d",
	   GetNameByAddr(GetMyAddr()), GetNameByAddr(remoteAddr), 
	   rate, wait, dur, sumNumPkts);
  }
  
  smallProbePtr->FinishReceiver(this, rate);
}

int SmallProbeReceiver::GetNonce() {
  return nonce;
}


int SmallProbeReceiver::GetAddr() {
  return remoteAddr;
}


int SmallProbeReceiver::GetMyAddr(){
  return(smallProbePtr->GetMyAddr());
}
