#ifndef SMALL_PROBE_H
#define SMALL_PROBE_H

#include "global.h"

class PerformanceAgent;
class PartitionAgent;
class SmallProbeSender;
class SmallProbeReceiver;
class GossipAgent;

class SmallProbe {
private:

  /* XXX: This timer thing is wicked!  We waste a lot of time writing code
   * to use a timer (need to create one extra .cc and .h file, and then
   * make changes to Makefile)
   */
  PerformanceAgent *performanceAgentPtr;
  PartitionAgent *partitionAgentPtr;
  GossipAgent *gossipAgentPtr;

  SmallProbeSender **sndPtr;
  SmallProbeReceiver **rcvPtr;
  int sndSize;
  int rcvSize;

  /* TRUE if the scheduled test has reported back the best candidate */
  int hasReport;  

  void ScheduleTest(int *remoteAddr, int size);

public:
  static const int SMALL_PROBE_FILE_SIZE = 10;  /* in KBytes */
  static const int SMALL_PROBE_PKT_SIZE = 1024;
  static const int SMALL_PROBE_NUM_PKTS 
    = SMALL_PROBE_FILE_SIZE * 1024 / SMALL_PROBE_PKT_SIZE;

  /* total time (in ms) receiver waits since the request pkt sends out */
  static const int SMALL_PROBE_RECEIVER_TIMEOUT = 2*1000;

  /* minimum ratio of pkts received to be counted as a valid probe*/
  static const float SMALL_PROBE_NUM_RCVD_RATIO = 0.8;

  SmallProbe(GossipAgent *gossipAgentPtr);
  ~SmallProbe();

  void ScheduleTest(int *remoteAddr, int size, PerformanceAgent *ptr);
  void ScheduleTest(int *remoteAddr, int size, PartitionAgent *ptr);

  void FinishSender(SmallProbeSender *smallProbeSenderPtr);
  void FinishReceiver(SmallProbeReceiver *smallProbeReceiverPtr,
		      int rate);

  void RecvMsg(int remoteAddr, int remotePort, GossipPayLoad *msg);

  /* ms */
  int GetProbePeriod();

  void SendToNetwork(int toAddr, int toPort,
		     GossipMsgType msgType,
		     SerializableObject *gossipMsgPtr);

  int GetMyAddr();
};

#endif



