#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <assert.h>

#include "gossipAgent.h"
#include "performanceAgent.h"
#include "partitionAgent.h"

#include "gossipPayLoad.h"
#include "smallProbe.h"
#include "smallProbeSender.h"
#include "smallProbeReceiver.h"


SmallProbe::SmallProbe(GossipAgent *gossipAgentPtr) {
  this->partitionAgentPtr = NULL;
  this->performanceAgentPtr = NULL;
  this->gossipAgentPtr = gossipAgentPtr;

  switch(protocolMetric){
  case BW_LATENCY:
    break;

  case BW_ONLY:
  case LATENCY_ONLY:
  case STATIC:
    MyError("No SmallProbe Mgr for STATIC tree!!!");
    break;

  default:
    MyError("Invalid Protocol Metric Type");
  }

  sndPtr = new (SmallProbeSender *)[MAX_ADDRESSES];
  rcvPtr = new (SmallProbeReceiver *)[MAX_ADDRESSES];

  for (int i=0; i<MAX_ADDRESSES; i++) {
    this->sndPtr[i] = NULL;
    this->rcvPtr[i] = NULL;
  }
  sndSize = 0;
  rcvSize = 0;

  hasReport = FALSE;
}


SmallProbe::~SmallProbe() {
  for (int j=0; j < sndSize; j++) {
    delete sndPtr[j];
  }
  
  for (int j=0; j < rcvSize; j++) {
    delete rcvPtr[j];
  }
}


void SmallProbe::FinishSender(SmallProbeSender *smallProbeSenderPtr) {
  assert(sndSize > 0);

  int i; for (i=0; i<sndSize; i++) {
    if (sndPtr[i] == smallProbeSenderPtr) {
      delete sndPtr[i];
      sndPtr[i] = NULL;
      
      sndSize--;
      sndPtr[i] = sndPtr[sndSize];
      return;
    }
  }
  
  MyError("SmallProbe: SmallProbeSender not found %d", sndSize);
}


void SmallProbe::ScheduleTest(int *remoteAddr, int size, 
			      PerformanceAgent *performanceAgentPtr) {
  if (rcvSize != 0) {
    MyWarning("\nSmallProbe: ScheduleTest from PerformanceAgent is duplicated: ignored");

    if (this->performanceAgentPtr != NULL) {
      MyWarning("\nSmallProbe: ScheduleTest: Earlier call from PerformanceAgent!!!");
    }

    performanceAgentPtr->ReportFromSmallProbe(-1);
    return;
  }

  this->performanceAgentPtr = performanceAgentPtr;
  this->partitionAgentPtr = NULL;

  ScheduleTest(remoteAddr, size);
}
		       

void SmallProbe::ScheduleTest(int *remoteAddr, int size, 
			      PartitionAgent *partitionAgentPtr) {
  if (rcvSize != 0) {
    MyWarning("\nSmallProbe: ScheduleTest from PartitionAgent is duplicated: ignored");
    if (this->partitionAgentPtr != NULL) {
      MyWarning("\nSmallProbe: ScheduleTest: Earlier call from PartitionAgent!!!");
    }
    partitionAgentPtr->ReportFromSmallProbe(-1);
    return;
  }

  this->partitionAgentPtr = partitionAgentPtr;
  this->performanceAgentPtr = NULL;

  ScheduleTest(remoteAddr, size);
}
		       

void SmallProbe::ScheduleTest(int *remoteAddr, int size) {
  assert(size > 0);

  rcvSize = size;
  hasReport = FALSE;

  for (int i=0; i<rcvSize; i++) {
    rcvPtr[i] = new SmallProbeReceiver(this, remoteAddr[i]);
    rcvPtr[i]->StartProbe();
  }
}


/* XXX: 
 * Right now, you cannot schedule another test until everyone finishes
 * the test (bounded by SMALL_PROBE_RECEIVER_TIMEOUT)
 * We could improve this by canceling all the ongoing parallel probing
 * when the *first* valid estimate is returned
 *
 * return -1 if no one in the set completes...
 */
void SmallProbe::FinishReceiver(SmallProbeReceiver *smallProbeReceiverPtr,
				int rate) {
  assert(rcvSize > 0);
  
  for (int i=0; i<rcvSize; i++) {
    if (rcvPtr[i] == smallProbeReceiverPtr) {
      int remoteAddr = smallProbeReceiverPtr->GetAddr();

      /* found */
      delete rcvPtr[i];
      rcvPtr[i] = NULL;
      
      rcvSize--;
      rcvPtr[i] = rcvPtr[rcvSize];

      if (hasReport == FALSE) {
	/* report only when rate > 0 or last to report*/
	if (rcvSize == 0 || rate >= 0) {
	  if (rate < 0) remoteAddr = -1;

	  if (performanceAgentPtr != NULL) {
	    performanceAgentPtr->ReportFromSmallProbe(remoteAddr);
	  } else if (partitionAgentPtr != NULL) {
	    partitionAgentPtr->ReportFromSmallProbe(remoteAddr);
	  } else {
	    MyError("SmallProbe: error");
	  }
	  
	  hasReport = TRUE;
	}
      }
      return;
    }
  }
  
  MyError("SmallProbe: SmallProbeReceiver not found %d", rcvSize);
}


void SmallProbe::RecvMsg(int remoteAddr, int remotePort, 
			 GossipPayLoad *gossipPacketPtr) {

  int gossipPacketCode=gossipPacketPtr->GetCode();
  SerializableObject *msg=gossipPacketPtr->GetMsg();
  
  switch(gossipPacketCode) {
  case SMALL_PROBE_REQUEST: {
    int nonce = ((SmallProbeRequestMsg *)msg)->GetNonce();
    sndPtr[sndSize] = new SmallProbeSender(this, remoteAddr, nonce);
    sndPtr[sndSize]->StartProbe();
    sndSize++;

    break;
  }

  case SMALL_PROBE_DATA: {
    int nonce = ((SmallProbeRequestMsg *)msg)->GetNonce();

    for (int i=0; i< rcvSize; i++) {
      if (rcvPtr[i]->GetAddr() == remoteAddr &&
	  rcvPtr[i]->GetNonce() == nonce) {
	rcvPtr[i]->RecvMsg((SmallProbeDataMsg *)msg);
	return;
      }
    }

    if (verbosity > 1) {
      printf("SmallProbe: recv undeliverable data from %s",
	     GetNameByAddr(remoteAddr));
    }
    break;
  }

  default:
    MyError("SmallProbe: unknown gossipPacketCode");
    break;
  }
  
}


int SmallProbe::GetProbePeriod() {
  int probeRate = MAX_SOURCE_RATE;

  if (probeRate <= 32) {
    probeRate=32;
  }
  
  int probePeriod = (int) ((SMALL_PROBE_PKT_SIZE * 8.0) / (float) probeRate);
  if(probePeriod < 1){
    probePeriod=1;
  }
  
  return probePeriod;
}


void SmallProbe::SendToNetwork(int toAddr, int toPort,
			       GossipMsgType msgType,
			       SerializableObject *gossipMsgPtr) {
  gossipAgentPtr->SendToNetwork(toAddr, toPort, msgType, gossipMsgPtr);
}


int SmallProbe::GetMyAddr() {
  return gossipAgentPtr->GetMyAddr();
}





