#ifndef PHYSICAL_DELAY_H
#define PHYSICAL_DELAY_H

class PhysicalDelay{
  static const int NUM_DELAY_WARMUP_ESTIMATES = 5;
  static const float ALPHA_DELAY = 0.01;
  static const int ABSOLUTE_DELAY_DIFF = 25;
  static const int ABSOLUTE_DELAY_DIFF_LC = 100;
  static const float RELATIVE_DELAY_DIFF = 0.25;
  
  float latencySmooth;
  int latencyMetric;

  int propagationDelay;
  
  int numDelayProbes;
  int lastDelayProbeTime;

  void UpdatePropagationDelay(int roundTripDelay);
  void UpdateDynamicLatency(int roundTripDelay);

 public:
  PhysicalDelay();


  void IntegrateDelayResult(int roundTripDelay);

  /*******
  Returns -1 if not probed 
  Returns time in milliseconds since last probe otherwise (>= 0)
  *********/

  int GetTimeSinceLastDelayProbe();

  int GetNumDelayProbes();

  /*******
  Returns -1 if no estimate.
  Returns a "smoothed" dynamic estimate of latency in milliseconds otherwise
   ( >= 0)
  ********/
   
  int GetDynamicLatency();

  float GetSmoothLatency();

  /*******
   Returns -1 if no estimate.
   Returns propagation delay in milliseconds otherwise
   ( >= 0) (minimum of all delay estimates)
  ********/
  int GetPropagationDelay();

  void Print();
};

#endif
