#include <assert.h>
#include <iostream.h>

#include "physicalBW.h"

PhysicalBW::PhysicalBW(){
  numBWProbes=0;
  numBWResultProbes=0;
  lastBWProbeTime=-1;
  physicalBWSmooth=-1;

}

int PhysicalBW::GetTimeSinceLastBWProbe(){
  if(numBWProbes == 0){
    return(-1);
  }
  else{
    return(GetCurrTime() - lastBWProbeTime);
  }
}

int PhysicalBW::GetNumBWProbes(){
  return(numBWProbes);
}

int PhysicalBW::GetNumBWResultProbes(){
  return(numBWResultProbes);
}

int PhysicalBW::GetBW(){
  if(numBWProbes == 0){
    return(-1);
  }
  else{
    return(physicalBWSmooth);
  }
}

void PhysicalBW::IntegrateBWResult(int estBW, BWResultType type){
  assert(estBW >= 0);

  if(numBWProbes == 0){
    physicalBWSmooth=estBW;
  }

  else if(numBWResultProbes == 0){
    switch(type){
    case BW_RESULT:
      physicalBWSmooth=estBW;
      break;
    case BW_RESULT_LB:
      if(estBW > physicalBWSmooth){
	physicalBWSmooth=estBW;
      }
      break;
    default:
      MyError("VrtEntry::IntegrateBWResult: unknown type");
      break;
    }
  }

  else{
    int timeSinceLastProbe=GetTimeSinceLastBWProbe();
    int timeInMinSinceLastProbe= (int) (timeSinceLastProbe/1000.0)/60;

    switch(type) {
    case BW_RESULT:
        physicalBWSmooth = 
	BWEstimationFunc(physicalBWSmooth, estBW, timeInMinSinceLastProbe);
      break;
    case BW_RESULT_LB:
      /* update only if lower bound estimate is better than current */
      if (physicalBWSmooth < estBW){ 
	physicalBWSmooth=
	  BWEstimationFunc(physicalBWSmooth, estBW, timeInMinSinceLastProbe);
      }
      break;
    default:
      MyError("VrtEntry::IntegrateBWResult: unknown type");
      break;
    }
  }

  numBWProbes++;
  lastBWProbeTime = GetCurrTime();
  if(type == BW_RESULT){
    numBWResultProbes++;
  }
}

int PhysicalBW::BWEstimationFunc(int oldBW, int newEstBW, int duration) {
  int retBW;
  float alpha;

  assert(duration >= 0);

  if (duration <= RECENT_TIME) {
    if(numBWProbes >= MIN_BW_WARMUP_ESTIMATES){
      alpha = BW_ALPHA_WARM_RECENT;
    }
    else{
      alpha = BW_ALPHA_COOL_RECENT;
    } 
  }
  else{
    alpha=BW_ALPHA_NONE_RECENT;
  }
  
  cout << "\n Using alpha = " << alpha;
  retBW = (int) ((newEstBW * alpha + oldBW * (100-alpha))/100);
  return retBW;
}

void PhysicalBW::Print(){
  cout << "\n Physical BW:";
  cout << " Smooth: " << physicalBWSmooth;
  cout << " NumProbes = " << numBWProbes;
  cout << " LBWProbeTime = " << lastBWProbeTime;
}

