#ifndef PATH_H
#define PATH_H

#include <Util/serializableObject.h>

class MyPath: public SerializableObject {
 public:
  static const int MAX_PATH_LEN = 70;  

  MyPath();

  void SetNoRoute();
  void SetZeroPath();

  int IsNoRoute();

  int IsInPath(int addrToCheck);
  int IsNextHop(int addr);
  
  /**********
   If nextHop is undefined: return -1, value of *nextHop not altered.
   If nextHop is defined: return 0, value of *nextHop has required value
  ************/
  int GetNextHop(int *nextHop);

  /* If no valid path: return -1
   * If you are the source: return 0
   * If the source is your parent: return 1
   */
  int GetPathLen();

  /* if k=0: return source */
  int GetKthHop(int k);

  void Merge(int addr,MyPath *pathToMerge);
  void Print();

  void ReadFromStream(InputSerializableStream *isPtr);
  void WriteToStream(OutputSerializableStream *osPtr);
  int Size();
  MyPath *Duplicate();

 private:

  static const int NO_ROUTE = -1;

  /******* 
   Padding to fill fields of the path vector that have no entries 
   (perhaps because there  were more fields than required
  *********/

  static const int NO_PATH_INFO = 0; 



  /*******
   contains path from me to destination
   does not include me, but includes destination
   pathLen is # of virtual hops to reach destination
  *********/
  int pathLen; // length of path to destination
  int path[MAX_PATH_LEN];    // path[0] gives the next hop if defined.


};

#endif  
