#ifndef NEIGHBOR_TAB_H
#define NEIGHBOR_TAB_H

#include <Util/estimateBandwidth.h>
#include "gossipPayLoad.h"

static const int NO_REPORT = -1;

static const int ESTIMATE_BW_HISTORY = 15;  /* 15 unit-time history */
static const int ESTIMATE_BW_UNIT = 1;      /* 1 second unit */

/* parameters to estimate bandwidth for bwRcvdFromNbr and bwSentToNbr */


class NbrTable{
 private:
  static const int MIN_SPURT_LENGTH = 15000;
  static const int MAX_IDLE_TIME = 2000;

  int numNbrs;
  struct NbrRecord{
    int addr;
    int tempFlag;  // Indicates if the nbr is temporary or not.
    int timeSinceTempNbr; // Relevant only if nbr becomes temporary
    int timeSinceNbr;
    int timeOfLastControlUpdate;
    ControlUpdateMsg *lastControlUpdate;
    EstimateBandwidth *bwRcvdFromNbr;
    EstimateBandwidth *bwSentToNbr;
    long bwSentByNbr;
    long lastBWReportTime;
    int numDataPktsSentToNbr;
    long timeLastDataPktSentToNbr;
    long timeCurrSpurtStarts;
    NbrRecord *next;
  };
  NbrRecord *nbrList;
  
 public:

  NbrTable();
  ~NbrTable();

  void AddNbr(int addr,long timeSinceNbr) ;
  void DropNbr(int addr);
  void MarkNbrTemp(int addr);

  int GetNumNbrs();
  int GetNumNonTempNbrs();
  void GetNbrList(int *nbrAddrList);
  long GetTimeSinceNbr(int addr);
  long GetTimeSinceTempNbr(int addr);

  int IsNbr(int addr); // 1 if yes, 0 if no;
  int IsTempNbr(int addr); // 1 if yes, 0 if no;
  int DoExistTempNbrs(); // 1 if yes, 0 if no

  void UpdateStatsRcvdFromNbr(int addr, int bytes);
  void UpdateStatsSentToNbr(int addr, int bytes);
  void UpdateRateSentByNbr(int addr, long newSendRate);
  


  /**********
    All the functions below return either a valid rate if information
    is available. Else the return UNDEFINED_RATE. UNDEFINED_RATE includes
    circumstances where the parent has started transmission after an
    idle period during the last 15 seconds. If however, it has been
    idle throughout the 15 seconds, rate is 0.
    In every case, the rate is the rate observed over the last 15 seconds.

    GetRateRcvdFromNbr: What rate am I receiving from the neighbor in the
                        last few (15) seconds?
    GetRateSentToNbr:   What rate am I sending data to neighbor in the last
                        few (15) seconds?
    GetRateSentByNbr:   What rate was the parent trying to send data in the 15 seconds
                        *before* the last packet arrived from it?
  ***********/	 

  long GetRateRcvdFromNbr(int addr);
  long GetRateSentToNbr(int addr);
  long GetRateSentByNbr(int addr);

  void UpdateLastBWReportTime(int addr);
  long GetLastBWReportTime(int addr);

  int PruneNbrList(long currTime,int timeout, int **deletedNbrsArrayPtr);

  int NbrStatusAndRefresh(int addr,
			  long currTime,
			  ControlUpdateMsg *controlUpdate); 
    // 2 if temporary, 1 if normal, 0 if not a nbr;

  ControlUpdateMsg *GetLastControlUpdate(int addr);

  void Print();
  void DoDebug(int myAddr);
};

#endif
