#ifndef GLOBAL_H
#define GLOBAL_H

#include <Util/macros.h>
/* 1 => no reduction 
 * gt 1 => reduction in timer value (for testing purpose)
 *         e.g. 3 => all timers are divided by 3
 */
#define TIMER_REDUCTION 1


/* global 
 */

enum PacketType {DATAPACKET,CONTROL,PROBE,POKE,MEASUREMENT};
#define PACKET_TYPE_SIZE 5
/* remember to change the PacketType string in gossipPayLoad.cc accordingly */
extern char *PACKET_TYPE_STR[PACKET_TYPE_SIZE]; 


extern void MyError(const char *format, ...);
extern void MyWarning(const char *format, ...);
extern char *GetNameByAddr(int addr);
extern long GetCurrTime();
extern void SetCurrTime(long time);

class TimerImp;
class Timer;
extern TimerImp *GetTimerImplementation(Timer *);

/* protocol-specific variables */
extern const int MAX_ADDRESSES;   // XXX maximum nodes that may be present

extern int GOSSIP_PORT;
extern int perPacketVerbosity;


extern int localCongestionSignal;
int IsLocalCongestionSignal();

/***** Parameters *******/
enum ProtocolMetricType {STATIC, LATENCY_ONLY, BW_ONLY, BW_LATENCY};
extern ProtocolMetricType protocolMetric;
void ParseProtocolMetric(char *optarg);

enum ProbeMethodType {RANDOM, RANDOM_10K, RANDOM_TFRC,
		      GNP, GNP_10K, GNP_TFRC,
		      RTT, RTT_10K, RTT_TFRC,
		      GNP_10K_TFRC, RTT_10K_TFRC,
		      HISTORY };

extern ProbeMethodType probeMethod;
void ParseProbeMethod(char *optarg);

extern int MAX_SOURCE_RATE;
extern int PROPAGATION_DELAY_FLAG;
class RoutingMetric;
RoutingMetric *CreateNewRoutingMetric();

/** Global variable ***/
const int MAX_PAYLOAD_SIZE = 20000;

/* performance history */
extern char *PerformanceHistoryReadFile;
extern char *PerformanceHistoryWriteFile;

extern int timeSyncServerAddr;

const int PRIORITY_DATA_DEFAULT = 10;
const int PRIORITY_POKE = 1;
const int PRIORITY_SMALL_PROBE = 5;
const int PRIORITY_CNTL_DEFAULT = 100;

#endif
