#ifndef DATA_AGENT_H
#define DATA_AGENT_H

#include "gossipPayLoad.h"

class GossipAgent;
class VirtualRoutingTable;
class NbrTable;
class SeqBuffer;
class EstimateBandwidth;
class CongestionCheckTimer;

class DataAgent{

 private:
  /*********
      maximum loss rate from parent to child, before we decide the link
      from parent to child has an available bandwidth lower than the parent
      rate
  **********/
  static const float MAX_LOSS_RATE_HIGH = 0.2; 
  static const float MAX_LOSS_RATE_LOW = 0.05; 

  /*********
       Bandwidth reports are made for each neighbor based on this period.
  ***********/
  static const int BW_REPORT_PERIOD = 15000; 
  
  static const int PERIODIC_CONGESTION_CHECK_TIME = 15000;
  static const float DROP_FACTOR_ON_CONGESTION = 0.1;
  static const float INITIAL_RISE_FACTOR_ON_CLEAR = 0.01;

  GossipAgent *gossipAgentPtr;
  VirtualRoutingTable *vrtPtr;
  NbrTable *nbrTabPtr;
  int seqNum;  /* seq num of sender (used by sender only) */

  // Sanjay: Questionable Correlated Congestion stuff
  float riseFactorOnClear;
  CongestionCheckTimer *congestionCheckTimer;

  /* forward a data msg, used by SendData() and Forward() */
  void ForwardDataMsg(DataMsg *dataMsgPtr);

 public:
  DataAgent(GossipAgent *gossipAgentPtrIn,
	    VirtualRoutingTable *vrtPtrIn,
	    NbrTable *nbrTabPtrIn);

  void Forward(int fromAddr,int fromPort,DataMsg *msgPtr);
  int GetMyAddr();
  void SendData(const char *buf,int bufLen, int priority);  // yhchu
  void DoDebug();
  void CongestionCheck();
};

#endif
