#include <iostream.h>
#include "childList.h"
#include "global.h"

ChildList::ChildList(int sourceAddrIn){
  numChildren=0;
  childList=NULL;
  sourceAddr=sourceAddrIn;
}

ChildList::~ChildList(){
  Destroy();
}
  
int ChildList::IsInChildList(int addr){
  ChildListType *ptr;
  
  for(ptr=childList; (ptr != NULL) && (ptr->addr != addr) ; ptr = ptr->next);
  if(ptr == NULL) return(0);
  else return(1);
}

void ChildList::Insert(int addr){
  ChildListType *ptr;
  for(ptr=childList; ptr != NULL && ptr->addr != addr; ptr=ptr->next);
  if(ptr == NULL){
    ChildListType *ptr = new ChildListType;
    ptr->addr=addr;
    ptr->next=childList;
    childList=ptr;
    numChildren++;
    PrintChildAdd(addr);
  }
}

void ChildList::Delete(int addr){
  if(childList == NULL) return;
  if(childList->addr == addr){
    numChildren--;
    ChildListType *ptr=childList;
    childList=childList->next;
    PrintChildDrop(addr);
    delete ptr;
    return;
  }
  
  ChildListType *ptr;
  for(ptr=childList; (ptr->next != NULL) && (ptr->next->addr != addr); ptr=ptr->next);
  if(ptr->next != NULL){
    numChildren--;
    ChildListType *deletePtr=ptr->next;
    ptr->next=deletePtr->next;
    PrintChildDrop(addr);
    delete deletePtr;
  }
  return;
}

void ChildList::Destroy(){
  ChildListType *ptr,*prevPtr;
  numChildren=0;
  for(ptr=childList; ptr != NULL; ){
    prevPtr=ptr;
    ptr=ptr->next;
    PrintChildDrop(prevPtr->addr);
    delete prevPtr;
  }  
  childList=NULL;
}

void ChildList::GetChildList(int *childAddrList){
  ChildListType *ptr;
  int i;
  
  for(ptr=childList,i=0; ptr != NULL; ptr=ptr->next,i++){
    childAddrList[i]=ptr->addr;
  }
}

int ChildList::GetNumChildren(){
  return(numChildren);
}

/*******************
void ChildList::Print(){
  cout << "\n numChildren = " << numChildren << " :";

  for(ChildListType *ptr=childList; ptr != NULL; ptr=ptr->next)
    cout << " " << GetNameByAddr(ptr->addr);
}
**********************/


void ChildList::Print(){
  cout << "\n Children : " ;
  for(ChildListType *ptr=childList; ptr != NULL; ptr=ptr->next)
    cout << " " << GetNameByAddr(ptr->addr);
}

void ChildList::PrintChildDrop(int droppedChildAddr){
  if(verbosity >= 1){
    cout << "\n" << GetCurrTime() << ":"
	 << "VRTEntryChange "
	 << GetNameByAddr(sourceAddr)
	 << " Child Drop "
	 << GetNameByAddr(droppedChildAddr);
  }
}

void ChildList::PrintChildAdd(int addedChildAddr){
  if(verbosity >= 1){
    cout << "\n" << GetCurrTime() << ":"
	 << "VRTEntryChange "
	 << GetNameByAddr(sourceAddr)
	 << " Child Add "
	 << GetNameByAddr(addedChildAddr);
  }
}
