#include <iostream.h>
#include "rttProbeTimer.h"
#include "../partitionAgent.h"
#include "../global.h"

RTTProbeTimer::RTTProbeTimer(PartitionAgent *partitionAgentPtrIn){
  partitionAgentPtr=partitionAgentPtrIn;
}

RTTProbeTimer::~RTTProbeTimer(){
}

void RTTProbeTimer::Expire(void){
  partitionAgentPtr->RTTProbeTimeout();
}

void RTTProbeTimer::PrintTimerInfo(void){
  if(verbosity > 0)
    cout << "\n" << GetCurrTime() << ": TIMER - RTT Probe Timer of " << 
      GetNameByAddr(partitionAgentPtr->GetMyAddr());
}
