#include <iostream.h>
#include "periodicPerformanceTimer.h"
#include "../performanceAgent.h"
#include "../global.h"

PeriodicPerformanceTimer::PeriodicPerformanceTimer(PerformanceAgent *performanceAgentPtrIn){
  performanceAgentPtr=performanceAgentPtrIn;
}

void PeriodicPerformanceTimer::Expire(void){
  performanceAgentPtr->PeriodicPerformanceCycle();
}

void PeriodicPerformanceTimer::PrintTimerInfo(void){
  if(verbosity > 0)
    cout << "\n" << GetCurrTime() << ": TIMER - Periodic Performance Timer of " << 
      GetNameByAddr(performanceAgentPtr->GetMyAddr());
}
