#include <iostream.h>
#include "periodicPartitionCheckTimer.h"
#include "../partitionAgent.h"
#include "../global.h"

PeriodicPartitionCheckTimer::PeriodicPartitionCheckTimer(PartitionAgent *partitionAgentPtrIn){
  partitionAgentPtr=partitionAgentPtrIn;
}

void PeriodicPartitionCheckTimer::Expire(void){
  partitionAgentPtr->PartitionCheck();
}

void PeriodicPartitionCheckTimer::PrintTimerInfo(void){
  if(verbosity > 0)
    cout << "\n" << GetCurrTime() << ": TIMER - Periodic Partition Timer of " << 
      GetNameByAddr(partitionAgentPtr->GetMyAddr());
}
